% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omu_summary.R
\name{omu_summary}
\alias{omu_summary}
\title{omu_summary
Performs comparison of means between two independent variables, standard deviation, standard error, FDR correction, fold change, log2FoldChange.
The order effects the fold change values}
\usage{
omu_summary(
  count_data,
  metadata,
  numerator,
  denominator,
  response_variable = "Metabolite",
  Factor,
  log_transform = FALSE,
  p_adjust = "BH",
  test_type = "welch",
  paired = FALSE
)
}
\arguments{
\item{count_data}{should be a metabolomics count data frame}

\item{metadata}{is meta data}

\item{numerator}{is the variable you wish to compare against the denominator, in quotes}

\item{denominator}{see above, in quotes}

\item{response_variable}{the name of the column with your response variables}

\item{Factor}{the column name for your independent variables}

\item{log_transform}{TRUE or FALSE value for whether or not log transformation of data is performed
before the t test}

\item{p_adjust}{Method for adjusting the p value, i.e. "BH"}

\item{test_type}{One of "mwu", "students", or "welch" to determine which model to use}

\item{paired}{A boolean of TRUE or FALSE. If TRUE, performs a paired sample test. To perform a paired sample test,
metadata must have a column named 'ID' containing the subject IDs.}
}
\description{
omu_summary
Performs comparison of means between two independent variables, standard deviation, standard error, FDR correction, fold change, log2FoldChange.
The order effects the fold change values
}
\examples{
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:12,]}
omu_summary(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
numerator = "Strep", denominator = "Mock", response_variable = "Metabolite", Factor = "Treatment",
log_transform = TRUE, p_adjust = "BH", test_type = "welch")
}
