## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(oncoPredict)

#Apply idwas() function.

#Determine the parameters of the idwas() function...
#Set the drug_prediction parameter.
#Make sure rownames() are samples, and colnames() are drugs. Also make sure this data is a data frame.
drug_prediction<-as.data.frame(read.table('DrugPredictions.txt', header=TRUE, row.names=1))
#In this example, I had to replace the '.' in the names of these TCGA samples with '-' so that they are of the same form as samples in the mutation  data (you may not have to do this).
colnames(drug_prediction)<-gsub(".", "-", colnames(drug_prediction), fixed=T)
#Make sure the sample identifiers in the 'drug prediction' data are of similar form as the sample identifiers in the 'data' parameter.
cols=colnames(drug_prediction)
colnames(drug_prediction)<-substring(cols, 3, nchar(cols))
drug_prediction<-as.data.frame(t(drug_prediction))

#This script provides an example of how to download mutation data from the GDC database for GBM (glioblastoma) and
#how to apply idwas() to test the drugs in your drug response dataset to each mutation to identify biomarkers that #enrich for drug response.

#Download mutation data for your cancer of interest from GDC database.

#GDCquery_Maf() downloads MAF (mutation annotation files) for glioblastoma (GBM).
#Other disease abbreviations include: "ACC", "BLCA", "BRCA", "CESC", "CHOL", "COAD", "COADREAD", "DLBC", "GBM", "GBMLGG", "HNSC", "KICH", "KIPAN", #"KIRC", "KIRP", "LAML", "LGG", "LIHC", "LUAD", "LUSC", "MESO", "OV", "PAAD", "PCPG", "PRAD", "READ", "SARC", "SKCM", "STAD", "STES", "TGCT", "THCA", #"THYM", "UCEC", "UCS", "UVM"
#library(TCGAbiolinks)
#maf<-GDCquery_Maf("GBM", pipelines = "muse")
maf<-read.table('maf.txt', header=TRUE, row.names=1)

#Set the data parameter.
#Make sure this data is a data frame and that colnames() are samples.
data<-as.data.frame(maf)
samps<-data$Tumor_Sample_Barcode
data$Tumor_Sample_Barcode<-substr(samps,1,nchar(samps)-12) #Make sure these sample ids are of the same form as the sample ids in your prediction data.

#Determine the number of samples you want the CNVs to be amplified in. The default is 10.
n=10

#Indicate whether or not you would like to test cnv data. If TRUE, you will test cnv data. If FALSE, you will test mutation data.
cnv=FALSE

original<-getwd()
wd<-tempdir()
savedir<-setwd(wd)

#Apply idwas()
#idwas(drug_prediction=drug_prediction, data=data, n=n, cnv=cnv)

setwd(original)

