% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_bins.R
\name{find_bins}
\alias{find_bins}
\title{Allocate markers into bins}
\usage{
find_bins(input.obj, exact = TRUE, ch = NULL)
}
\arguments{
\item{input.obj}{an object of class \code{onemap}.}

\item{exact}{logical. If \code{TRUE}, it only allocates markers with
the exact same information into bins, including missing data; if
\code{FALSE}, missing data are not considered when allocating markers.
In the latter case, the marker with the lowest amount of missing data is
taken as the representative marker on that bin.}

\item{ch}{not used in this OneMap version. Chromosome for which the
analysis should be performed. If \code{NULL} the analisys is performed
for all chromosomes.}
}
\value{
An object of class \code{onemap_bin}, which is a list containing the
following components: \item{bins}{a list containing the bins. Each element of
the list is a table whose lines indicate the name of the marker, the bin in
which that particular marker was allocated and the percentage of missing data.
The name of each element of the list corresponds to the marker with the lower
amount of missing data among those on the bin}\item{n.mar}{total number of markers.}
\item{n.ind}{number individuals} \item{exact.search}{logical; indicates if
the search was performed with the argument \code{exact=TRUE} or \code{exact=FALSE}}
}
\description{
Function to allocate markers with redundant information into bins.
Within each bin, the pairwise recombination fraction between markers is zero.
}
\examples{
 \dontrun{
  load(url("https://github.com/mmollina/data/raw/master/fake_big_data_f2.RData"))
  fake.big.data.f2
  (bins<-find_bins(fake.big.data.f2, exact=FALSE))}
}
\seealso{
\code{\link[onemap]{create_data_bins}}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{bins}
\keyword{dimension}
\keyword{reduction}
