% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_upgma.R
\name{group_upgma}
\alias{group_upgma}
\title{Assign markers to linkage groups}
\usage{
group_upgma(input.seq, expected.groups = NULL, inter = TRUE, comp.mat = FALSE)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.rf.matrix}}

\item{expected.groups}{when available, inform the number of expected 
linkage groups (i.e. chromosomes) for the species}

\item{inter}{if \code{TRUE} (default), plots a dendrogram highlighting the
expected groups before continue}

\item{comp.mat}{if \code{TRUE}, shows a comparison between the reference
based and the linkage based grouping, if the sequence information is
available (default = FALSE)}
}
\value{
Returns an object of class \code{group}, which is a list
    containing the following components:
    \item{data.name}{the referred dataset name}
    \item{hc.snp}{a list containing information related to 
    the UPGMA grouping method}
    \item{expected.groups}{the number of expected linkage groups}
    \item{groups.snp}{the groups to which each of the markers belong}
    \item{seq.vs.grouped.snp}{comparison between the genomic group information
    (when available) and the groups provided by \code{group_upgma}}
    \item{LOD}{minimum LOD Score to declare linkage.} 
    \item{max.rf}{maximum recombination fraction to declare linkage.}
    \item{twopt}{name of the object of class \code{rf.2ts}
    used as input, i.e., containing information used to assign
    markers to linkage groups.}
}
\description{
Identifies linkage groups of markers using the results of two-point
(pairwise) analysis and UPGMA method. Function adapted from MAPpoly package
written by Marcelo Mollinari.
}
\examples{
\donttest{
data("vcf_example_out")
twopts <- rf_2pts(vcf_example_out)
input.seq <- make_seq(twopts, "all")
lgs <- group_upgma(input.seq, expected.groups = 3, comp.mat=TRUE, inter = FALSE)
plot(lgs)
}
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}

Cristiane Taniguti \email{chtaniguti@tamu.edu}
}
