% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{as.oClass}
\alias{as.oClass}
\title{Convert Object to an oClass Generator}
\usage{
as.oClass(
  x,
  name = NULL,
  inherit = NULL,
  portable = FALSE,
  hash = FALSE,
  formals = NULL,
  deep = TRUE,
  ...
)
}
\arguments{
\item{x}{object to be cloned and converted}

\item{name}{character string describing the name of the class}

\item{inherit}{oClass used as the \code{\link[base]{parent.env}} for the generated instances}

\item{portable}{logical indicating whether all inherited values should be copied into each instance}

\item{hash}{logical indicating whether instances should use hashing, see \code{\link[base]{new.env}}}

\item{formals}{list containing the formal arguments for the resulting generator function. These are passed to the \code{\link{init}} function when a new instance is created.}

\item{deep}{logical. Should the object be deep-cloned?}

\item{...}{named fields inherited by the class instance}
}
\value{
a function of class \code{"ClassGenerator"} with attributes describing each generated class instance
}
\description{
This function takes any named object such as an environment, fully-named list, or an Instance
and converts it to an \code{\link{oClass}} generator function so that instances have
access to the fields in the named object. See \code{\link{oClass}} for details about the
arguments and functionality of the oClass generator.
}
