% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resources_perm_delete}
\alias{opal.resources_perm_delete}
\title{Delete a permission from any resource}
\usage{
opal.resources_perm_delete(opal, project, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{The project name.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}
}
\description{
Delete a permission that was applied globally on the project's resources. Silently returns when there is no such permission.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resources_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.resources_perm(o, 'CNSIM', 'CNSIM1')
opal.resources_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other resource functions: 
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_delete}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resource_perm_add}()},
\code{\link{opal.resource_perm_delete}()},
\code{\link{opal.resource_perm}()},
\code{\link{opal.resources_perm_add}()},
\code{\link{opal.resources_perm}()},
\code{\link{opal.resources}()},
\code{\link{opal.resource}()}
}
\concept{resource functions}
