% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{oa_combine}
\alias{oa_combine}
\title{Combine data helper}
\usage{
oa_combine(...)
}
\arguments{
\item{...}{Data sets, all need to be of class \code{oa}}
}
\value{
a tibble (a data.frame) of all the inputs combined, with attributes for
original urls and paths on disk
}
\description{
Combine data helper
}
\details{
Gives back a single \code{tbl_df}, with a subset of columns, currently
\code{lon}, \code{lat}, and \code{address}.

This function attempts to combine, but may fail sometimes.
}
\examples{
\dontrun{
dat <- oa_list()

out1 <- oa_get(dat$processed[5])
out2 <- oa_get(dat$processed[35])
(alldat <- oa_combine(out1, out2))

out4 <- oa_get(dat$processed[788])
(alldat <- oa_combine(out2, out4))

if (!requireNamespace("leaflet")) {
  install.packages("leaflet")
}
library("leaflet")
leaflet(alldat) \%>\%
  addTiles() \%>\%
  addCircles(lat = ~lat, lng = ~lon, popup = ~address)
}
}

