% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-satgpa.R
\docType{data}
\name{satgpa}
\alias{satgpa}
\title{SAT and GPA data}
\format{
A data frame with 1000 observations on the following 6 variables.
\describe{
\item{sex}{Gender of the student.}
\item{sat_v}{Verbal SAT percentile.}
\item{sat_m}{Math SAT percentile.}
\item{sat_sum}{Total of verbal and math SAT percentiles.}
\item{hs_gpa}{High school grade point average.}
\item{fy_gpa}{First year (college) grade point average.}
}
}
\source{
Educational Testing Service originally collected the data.
}
\usage{
satgpa
}
\description{
SAT and GPA data for 1000 students at an unnamed college.
}
\examples{

library(ggplot2)
library(broom)

# Verbal scores
ggplot(satgpa, aes(x = sat_v, fy_gpa)) +
  geom_point() +
  geom_smooth(method = "lm") +
  labs(
    x = "Verbal SAT percentile",
    y = "First year (college) grade point average"
  )

mod <- lm(fy_gpa ~ sat_v, data = satgpa)
tidy(mod)

# Math scores
ggplot(satgpa, aes(x = sat_m, fy_gpa)) +
  geom_point() +
  geom_smooth(method = "lm") +
  labs(
    x = "Math SAT percentile",
    y = "First year (college) grade point average"
  )

mod <- lm(fy_gpa ~ sat_m, data = satgpa)
tidy(mod)
}
\references{
\url{https://chance.dartmouth.edu/course/Syllabi/Princeton96/ETSValidation.html}
}
\keyword{datasets}
