% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume-control.R
\name{volume-control}
\alias{volume-control}
\alias{channel_mute_status}
\alias{channel_mute_status<-}
\alias{channel_volume}
\alias{channel_volume<-}
\alias{global_volume}
\alias{global_volume<-}
\title{Control the volume of a module}
\usage{
channel_mute_status(mod, channel, ...)

channel_mute_status(mod, channel, ...) <- value

channel_volume(mod, channel, ...)

channel_volume(mod, channel, ...) <- value

global_volume(mod, ...)

global_volume(mod, ...) <- value
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{channel}{Channel index (\code{integer} starting at \code{0}) for which
to request or control the volume.}

\item{...}{Ignored}

\item{value}{Replacement value. In case of '\code{status}' functions
a \code{logical} value, in case of '\code{volume}' functions a \code{numeric} value.}
}
\value{
Returns the volume (status), or the updated object in case
of an assign operation (\verb{<-}).
}
\description{
Functions to control the global volume of a module, or that
of specific channels in the module.
}
\examples{
mod <- demo_mod()

channel_mute_status(mod, 0L)

## Mute the first channel in the module
channel_mute_status(mod, 0L) <- TRUE

## Second channel volume at 50\%
channel_volume(mod, 1L) <- 0.5
channel_volume(mod, 1L)

## global volume at 90\%
global_volume(mod) <- 0.9
global_volume(mod)

}
