% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_eff.R
\name{design_efficiency}
\alias{design_efficiency}
\title{Efficiency between optimal design and a user given design}
\usage{
design_efficiency(opt_des_obj, design)
}
\arguments{
\item{opt_des_obj}{an object given by the function \code{opt_des}.}

\item{design}{dataframe that represents the design. Must have two columns:
\itemize{
\item \code{Point} contains the support points of the design.
\item \code{Weight} contains the corresponding weights of the \code{Point}s.
}}
}
\value{
The efficiency as a value between 0 and 1
}
\description{
Takes an optimal design provided from the function \code{opt_des} and a user given design and compares their
efficiency
}
\examples{
result <- opt_des("D-Optimality", y ~ a * exp(-b / x), c("a", "b"), c(1, 1500), c(212, 422))
design <- data.frame("Point" = c(220, 240, 400), "Weight" = c(1 / 3, 1 / 3, 1 / 3))
design_efficiency(result, design)
}
\seealso{
opt_des
}
