% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-supplementation.r
\name{supplementation}
\alias{supplementation}
\alias{recover_supp_rows}
\alias{recover_supp_rows.default}
\alias{recover_supp_cols}
\alias{recover_supp_cols.default}
\title{Supplement 'tbl_ord' objects with new data}
\usage{
recover_supp_rows(x)

\method{recover_supp_rows}{default}(x)

recover_supp_cols(x)

\method{recover_supp_cols}{default}(x)
}
\arguments{
\item{x}{An object of class '\link{tbl_ord}'.}
}
\value{
Matrices having the same numbers of columns as returned by
\code{\link[=recover_rows]{recover_rows()}} and \code{\link[=recover_cols]{recover_cols()}}, or else \code{NULL}.
}
\description{
These functions attach supplementary rows or columns to an
ordination object.
}
\details{
The \verb{recover_supp_*()} \link[base:UseMethod]{S3 methods} produce matrices of
supplemental rows or columns of a \link{tbl_ord} object from the object itself.
The motivating example is linear discriminant analysis, which produces a
natural biplot of class discriminant centroids and variable axes but is
usually supplemented with case discriminant scores. The supplementary values
are augmented with an \code{.element} column whose value indicates their source
and can be incorporated into a \link[=fortify]{tidied form}. If no supplementary
rows of a factor are produced, the functions return \code{NULL}.
}
\seealso{
Other generic recoverers: 
\code{\link{augmentation}},
\code{\link{conference}},
\code{\link{recoverers}}
}
\concept{generic recoverers}
