% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.loca.p.R
\name{contour.loca.p}
\alias{contour.loca.p}
\alias{contour,loca.p-method}
\title{Plots of the min-sum objective function}
\usage{
\method{contour}{loca.p}(x, lp = numeric(0), xmin = min(min(x@x), xleft),
  xmax = max(max(x@x), xright), ymin = min(min(x@y), ybottom),
  ymax = max(max(x@y), ytop), n = 100, img = NULL, xleft = min(x@x),
  ybottom = min(x@y), xright = max(x@x), ytop = max(x@y), ...)
}
\arguments{
\item{x}{The loca.p object to compute the objective.}

\item{lp}{If given, then \eqn{l_p} norm will be used instead of the Euclidean norm.}

\item{xmin}{The minimum value for x axis.}

\item{xmax}{The maximum value for x axis.}

\item{ymin}{The minimum value for y axis.}

\item{ymax}{The maximum value for y axis.}

\item{n}{The number of divisions for grid.}

\item{img}{A raster image to plot on background.}

\item{xleft}{The left position of the image.}

\item{ybottom}{The bottom position of the image.}

\item{xright}{The right position of the image.}

\item{ytop}{The top position of the image.}

\item{\ldots}{Other options.}
}
\value{
\code{contour.loca.p} plots a contour plot of min-sum function (\code{zsum}).
}
\description{
\code{contour} provides a graphical representations of min-sum function (\code{zsum}).
}
\details{
If \eqn{p<1} then \eqn{l_p} ara not a norm, so only \eqn{p>=1} are valid values.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))

# The contour plot of min-sum function for loca (a loca.p object)
contour(loca)

}
\seealso{
See also \code{\link{orloca-package}}, \code{\link{plot.loca.p}} and \code{\link{loca.p}}.
}
\keyword{classes}
\keyword{hplot}
