% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-extract.R
\name{osm_multilines}
\alias{osm_multilines}
\title{Extract all \code{osm_multilines} from an osmdata object}
\usage{
osm_multilines(dat, id)
}
\arguments{
\item{dat}{An object of class \link{osmdata}}

\item{id}{OSM identification of one of more objects for which multilines are
to be extracted}
}
\value{
An \pkg{sf} Simple Features Collection of multilines
}
\description{
\code{id} must be of an \code{osm_points} or \code{osm_lines} object (and can
not be the \code{id} of an \code{osm_polygons} object because multilines by
definition contain no polygons.  \code{osm_multilines} returns any multiline
object(s) which contain the object specified by \code{id}.
}
\examples{
\dontrun{
dat <- opq ("London UK") \%>\%
    add_osm_feature (key="name", value="Thames", exact=FALSE) \%>\%
    osmdata_sf ()
# Get ids of lines called "The Thames":
id <- rownames (dat$osm_lines [which (dat$osm_lines$name == "The Thames"),])
# and find all multilinestring objects which include those lines:
osm_multilines (dat, id)
# Now note that
nrow (dat$osm_multilines) # = 24 multiline objects
nrow (osm_multilines (dat, id)) # = 1 - the recursive search selects the
                                # single multiline containing "The Thames"
}
}
\seealso{
Other search: 
\code{\link{osm_lines}()},
\code{\link{osm_multipolygons}()},
\code{\link{osm_points}()},
\code{\link{osm_polygons}()}
}
\concept{search}
