% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_tssd_ewma.R
\name{CpTsSdEwma}
\alias{CpTsSdEwma}
\title{Classic Processing Two-Stage Shift-Detection based on EWMA}
\usage{
CpTsSdEwma(data, n.train, threshold = 0.01, l = 3, m = 5)
}
\arguments{
\item{data}{Numerical vector with training and test dataset.}

\item{n.train}{Number of points of the dataset that correspond to the training set.}

\item{threshold}{Error smoothing constant.}

\item{l}{Control limit multiplier.}

\item{m}{Length of the subsequences for applying the Kolmogorov-Smirnov test.}
}
\value{
dataset conformed by the following columns:

  \item{is.anomaly}{1 if the value is anomalous, 0 otherwise.}
  \item{ucl}{Upper control limit.}
  \item{lcl}{Lower control limit.}
}
\description{
\code{CpTsSdEwma} calculates the anomalies of a dataset using
classical processing based on the SD-EWMA algorithm. This algorithm is a
novel method for covariate shift-detection tests based on a two-stage
structure for univariate time-series. This algorithm works in two phases. In
the first phase, it detects anomalies using the SD-EWMA
\code{\link{CpSdEwma}} algorithm. In the second phase, it checks the veracity
of the anomalies using the Kolmogorov-Simirnov test to reduce false alarms.
See also \code{\link{OcpTsSdEwma}}, the optimized and faster function of this
function.
}
\details{
\code{data} must be a numerical vector without NA values.
\code{threshold} must be a numeric value between 0 and 1.
It is recommended to use low values such as 0.01 or 0.05. By default, 0.01 is
used. Finally, \code{l} is the parameter that determines the control limits.
By default, 3 is used. \code{m} is the length of the subsequences for
applying the Kolmogorov-Smirnov test. By default, 5 is used. It should be
noted that the last \code{m} values will not been verified because another
\code{m} values are needed to be able to perform the verification.
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

## Calculate anomalies
result <- CpTsSdEwma(
  data = df$value,
  n.train = 5,
  threshold = 0.01,
  l = 3,
  m = 20
)
res <- cbind(df, result)

## Plot results
PlotDetections(res, title = "TSSD_EWMA ANOMALY DETECTOR")
}
\references{
Raza, H., Prasad, G., & Li, Y. (03 de 2015). EWMA model based
shift-detection methods for detecting covariate shifts in non-stationary
environments. Pattern Recognition, 48(3), 659-669.
}
