% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_VLE_time.R
\name{dataset_VLE_time}
\alias{dataset_VLE_time}
\title{Returns the formatted VLE data set for daily and weekly counts}
\usage{
dataset_VLE_time(
  module = c("AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG"),
  presentation = c("2013B", "2014B", "2013J", "2014J", "All"),
  repeat_students = c("remove", "keep"),
  week_begin = -4,
  week_end = 39,
  example_data = FALSE
)
}
\arguments{
\item{module}{name of the module to be included, either \code{"AAA"}, \code{"BBB"}, \code{"CCC"}, \code{"DDD"}, \code{"EEE"}, \code{"FFF"} or \code{"GGG"}.}

\item{presentation}{name of the semester of the module to be included, either \code{"2013B"},
\code{"2014B"}, \code{"2013J"}, \code{"2014J"}, or \code{"All"}.
\code{"B"} indicates a February start time whereas \code{"J"} indicates an October start time. \code{"All"} indicates that all presentations of the module will be included in the returned data.}

\item{repeat_students}{indicator of whether students who had previous attempts at the module should be removed, either \code{"remove"} or \code{"keep"}.
If presentation is set to \code{"All"}, this is automatically set to \code{"remove"}.}

\item{week_begin}{the first semester week of VLE data to be included in formatted data. Depending on the module presentation, students
started to view activities four weeks prior to the initial module start date. Weeks prior to the initial module start
are indicated by a negative integer.}

\item{week_end}{the last semester week of VLE data to be included in the formatted data.
Week 39 is the last week material was viewed (and earlier in some module presentations).}

\item{example_data}{logical. Indicates whether to run a subset of the data as an example.}
}
\value{
Returns three \code{tibbles} (objects of class \code{tbl_df}) based on the OULAD studentVle.csv file,
the specified inputs (module, presentation, and repeat_students), and
the range of the weeks included in the \code{tibbles}. \code{week_begin} and \code{week_end}
indicates the first and last semester week respectively that is included in
the output \code{tibbles}. These may be different to the input parameters of  \code{week_begin} and \code{week_end}.
Weeks prior to the initial module start day are indicated by a negative integer.
The three \code{tibbles} returned are: 1) filtered_data, 2) daily_data, and 3) weekly_data.
}
\description{
Load and formats the student Virtual Learning Environment (VLE) data set from the OULAD for data analysis.
}
\section{filtered_data tibble}{

A \code{tibble} based on the students' VLE interactions and the inputs. The \code{tibble} consists of (Kuzilek et al., 2017):

\itemize{
\item{id_student - the unique student identification number.}
\item{code_module - the module identification code.}
\item{code_presentation - the presentation identification code.}
\item{id_site - the VLE material identification number.}
\item{date - the day of the student’s interaction with the material.}
\item{sum_click - the number of times the student interacted with the material on a specific day.}
}
}

\section{daily_data tibble}{

A \code{tibble} where each row represents a unique student, and each column their number of interactions with
the VLE for different days of the module. The module starts on day 0. Days prior to the initial start day, are indicated by negative integers.
}

\section{weekly_data tibble}{

A \code{tibble} where each row represents a unique student, and each column their number of interactions with
the VLE for different weeks of the module. Weeks prior to the initial start week (week 1) are indicated by the term 'pre' in the week name.
}

\examples{
# Uses subset of the VLE data set for example
dataset_VLE_time(example_data = TRUE)
\donttest{
# Slow to run as it loads the full VLE data set
dataset_VLE_time(module = "BBB", presentation = "2013J",
repeat_students = "remove", week_begin = 1, week_end = 13,
example_data=FALSE)}
}
\references{
Kuzilek, J., Hlosta, M., & Zdrahal, Z. (2017). Open university learning analytics dataset. Scientific Data
volume 4 , (pp. 1–8). https://doi.org/10.1038/sdata.2017.171.
}
\seealso{
\code{\link[=convert_VLE]{convert_VLE()}}, \code{\link[=dataset_VLE_activity]{dataset_VLE_activity()}}, and \code{\link[=combined_dataset]{combined_dataset()}}
}
