% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.outForest}
\alias{plot.outForest}
\title{Plots outForest}
\usage{
\method{plot}{outForest}(x, what = c("counts", "scores"), ...)
}
\arguments{
\item{x}{An object of class "outForest".}

\item{what}{What should be plotted? One of "counts" (the default) or "scores".}

\item{...}{Further arguments passed to \code{graphics::barplot()} or
\code{graphics::stripchart()}.}
}
\value{
A list.
}
\description{
This function can plot aspects of an "outForest" object.
For \code{what = "counts"}, the number of outliers per variable is visualized as a barplot.
For \code{what = "scores"}, outlier scores (i.e. the scaled difference between
predicted and observed value) are shown as scatter plot per variable.
}
\examples{
irisWithOutliers <- generateOutliers(iris, seed = 345)
x <- outForest(irisWithOutliers, verbose = 0)
plot(x)
plot(x, what = "scores")
}
