% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args.R
\name{wd_get}
\alias{wd_get}
\title{Return working directory}
\usage{
wd_get(arglist, key = NULL, i = NULL)
}
\arguments{
\item{arglist}{Arguments as character vector}

\item{key}{Argument key identifying the working directory, e.g. -wd}

\item{i}{Index in the arglist that determines the working directory, e.g. 1.}
}
\value{
Character
}
\description{
Utility function for determining the working directory from 
arglist. The working directory can be determined from the arglist either by
a key:value or an index. For example, the working directory may be determined
by the key \code{-wd} in which case this function will identify whether this
key exists in the arglist and will return its corresponding value.
Alternatively, the working directory may be determined by the first argument
(e.g. an input file), in which case setting \code{i=1} will return the first
argument in the arglist.
If an input file is returned, a user can use \code{\link{dirpath_get}} to
convert the file path to a directory path.
If both \code{key} and \code{i} are provided, \code{key} takes precedence.
If no \code{key} or \code{i} is provided and/or no working directory is
found in the arguments, the function will return the R session's working
directory.
If no arguments are provided, returns empty character vector.
}
\examples{
library(outsider.base)
# wd is determined by key argument
arglist <- c('-a', 10, '-wd', 'path/to/wd', '-b', 'model2')
(wd_get(arglist = arglist, key = '-wd'))
# wd is determined by an index
arglist <- c('path/to/wd', '-a', 10, '-b', 'model2')
(wd_get(arglist = arglist, i = 1))
}
