% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_plot.R
\name{owid_plot}
\alias{owid_plot}
\title{Plot an owid dataset}
\usage{
owid_plot(
  data = NULL,
  col = 4,
  summarise = TRUE,
  filter = NULL,
  years = NULL,
  show.all = FALSE
)
}
\arguments{
\item{data}{A tibble returned from `owid()`}

\item{col}{Either the column number to be treated as the value or a character string specifying the name of the value column. Defaults to 3, which is the first possible value column.}

\item{summarise}{A logical value. If TRUE, plot takes the mean value. If FALSE, each entity is plotted, it is recommended to use this in conjunction with the filter argument to avoid too many entity's being plotted.}

\item{filter}{The entity's to include in the plot.}

\item{years}{The years to be included in the plot.}

\item{show.all}{A logical value indicating weather all Entities should be included in the plot.}
}
\value{
A ggplot object.
}
\description{
A wrapper around ggplot to provide an quick visualisation of owid data.
}
\examples{

human_rights <- owid("human-rights-scores")

# Plot average score over time
owid_plot(human_rights)
\donttest{
# Plot score for a selection of countries
owid_plot(human_rights, summarise = FALSE,
          filter = c("United Kingdom", "Sweden", "North Korea", "South Korea"))
}

}
