################################################################################
#
#'
#' Data sources for OxCOVID19 Database
#'
#' @format A named list of 5 tibbles of data sources.
#' \describe{
#'   \item{\code{epidemiology}}{Tibble of sources for epidemiology table}
#'   \item{\code{government_response}}{Tibble of sources for government
#'     response table}
#'   \item{\code{country_statistics}}{Tibble of sources for country statistics
#'     table}
#'   \item{\code{mobility}}{Tibble of sources for mobility table}
#'   \item{\code{weather}}{Tibble of sources for weather table}
#' }
#'
#' @examples
#' data_sources
#'
#' @source \url{https://covid19.eng.ox.ac.uk/data_sources.html}
#'
#
################################################################################
"data_sources"


################################################################################
#
#'
#' Data structures for OxCOVID19 Database
#'
#' @format A named list of 6 tibbles of data structures.
#' \describe{
#'   \item{\code{epidemiology}}{Tibble of description of fields for epidemiology
#'     table}
#'   \item{\code{government_response}}{Tibble of description of fields for
#'     government response table}
#'   \item{\code{country_statistics}}{Tibble of description for fields for
#'     country statistics table}
#'   \item{\code{mobility}}{Tibble of description for fields for mobility table}
#'   \item{\code{weather}}{Tibble of description for fields for weather table}
#'   \item{\code{administrative_division}}{Tibble of description for fields for
#'     administrative division table}
#' }
#'
#' @examples
#' data_structures
#'
#' @source \url{https://covid19.eng.ox.ac.uk/data_schema.html}
#'
#
################################################################################
"data_structures"

