% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCODE.R
\name{pcode_1d}
\alias{pcode_1d}
\title{Parameter Cascade Method for Ordinary Differential Equation Models (Single dimension version)}
\usage{
pcode_1d(data, time, ode.model, par.initial,par.names, basis,lambda,controls = list())
}
\arguments{
\item{data}{A data frame or a vector contains observations from the ODE model.}

\item{time}{The vector contain observation times.}

\item{ode.model}{Defined R function that computes the time derivative of the ODE model given observations of states variable.}

\item{par.initial}{Initial value of structural parameters to be optimized.}

\item{par.names}{The names of structural parameters defined in the 'ode.model'.}

\item{basis}{A basis objects for smoothing observations.}

\item{lambda}{Penalty parameter.}

\item{controls}{A list of control parameters. See ‘Details’.}
}
\value{
\item{structural.par}{The structural parameters of the ODE model.}

\item{nuisance.par}{The nuisance parameters or the basis coefficients for interpolating observations.}
}
\description{
Obtain estiamtes of structural parameters of an ODE model by parameter cascade method.
}
