% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_parameter_estimation_survival.R
\name{plot_prediction_parametric_survival}
\alias{plot_prediction_parametric_survival}
\title{Plot the predicted survival curves for covariates keeping the others fixed}
\usage{
plot_prediction_parametric_survival(
  param_to_be_estimated,
  indep_var,
  covariates,
  dataset,
  fit,
  timevar_survival
)
}
\arguments{
\item{param_to_be_estimated}{parameter to be estimated}

\item{indep_var}{variable for which the levels have to be identified}

\item{covariates}{the  covariates}

\item{dataset}{the dataset where these variables contain}

\item{fit}{the fit result survreg}

\item{timevar_survival}{time variable from the dataset}
}
\value{
plot
}
\description{
Plot the predicted survival curves for covariates keeping the others fixed
}
\examples{
\donttest{
data_for_survival <- survival::lung
surv_estimated <- use_parametric_survival("status", data_for_survival, "sex",
info_distribution = "weibull",covariates = c("ph.ecog"),"time")
plot_prediction_parametric_survival("status", "sex",
covariates = c("ph.ecog"),data_for_survival, surv_estimated$fit, "time")
}
}
