% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_downloads2.R
\name{cran_downloads2}
\alias{cran_downloads2}
\title{Daily package downloads from the RStudio CRAN mirror.}
\usage{
cran_downloads2(packages = NULL, when = c("last-day", "last-week",
  "last-month"), from = "last-day", to = "last-day")
}
\arguments{
\item{packages}{A character vector, the packages to query,
or \code{NULL} for a sum of downloads for all packages.
Alternatively, it can also be \code{"R"}, to query downloads
of R itself. \code{"R"} cannot be mixed with packages.}

\item{when}{\code{last-day}, \code{last-week} or \code{last-month}.
If this is given, then \code{from} and \code{to} are ignored.}

\item{from}{Start date, in \code{yyyy-mm-dd} format, or
\code{last-day}. It is ignored if \code{when} is given.}

\item{to}{End date, in \code{yyyy-mm-dd} format, or
\code{last-day}. It is ignored if \code{when} is given.}
}
\description{
S3 implementation of cranlogs::cran_downloads().
}
\examples{
\donttest{
cran_downloads2(packages = "HistData", from = "2019-01-01", to = "2019-01-01")
cran_downloads2(packages = c("Rcpp", "rlang"), when = "last-week")
}
}
