% Generated by roxygen2 (4.0.2): do not edit by hand
\name{snapshot}
\alias{snapshot}
\title{Capture and store the packages and versions in use}
\usage{
snapshot(project = NULL, available = available.packages(),
  lib.loc = libDir(project), ignore.stale = FALSE, dry.run = FALSE,
  prompt = interactive())
}
\arguments{
\item{project}{The project directory. Defaults to current working
directory.}

\item{available}{A database of available packages.}

\item{lib.loc}{The library to snapshot. Defaults to the private library
associated with the given directory.}

\item{ignore.stale}{Stale packages are packages that are different from the
last snapshot, but were installed by packrat. Typically, packages become
stale when a new snapshot is available, but you haven't applied it yet with
\code{\link{restore}}. By default, packrat will prevent you from taking a
snapshot when you have stale packages to prevent you from losing changes
from the unapplied snapshot. If your intent is to overwrite the last
snapshot without applying it, use \code{ignore.stale = TRUE} to skip this
check.}

\item{dry.run}{Computes the changes to your packrat state that would be made
if a snapshot were performed, and prints them to the console.}

\item{prompt}{\code{TRUE} to prompt before performing snapshotting package
  changes that might be unintended; \code{FALSE} to perform these operations
  without confirmation. Potentially unintended changes include snapshotting
  packages at an older version than the last snapshot, or missing despite
  being present in the last snapshot.}
}
\description{
Finds the packages in use in the project, and stores a list
of those packages, their sources, and their current versions in packrat.
}
\note{
\code{snapshot} modifies the project's \code{packrat.lock} file, and
the sources stored in the project's \code{packrat/src} directory. If you
are working with a version control system, your collaborators can sync the
changes to these files and then use \code{\link{restore}} to apply your
snapshot.
}
\examples{
\dontrun{
# Take a snapshot of the current project
snapshot()

# See what changes would be included in a snapshot
snapshot(dry.run = TRUE)

}
}
\seealso{
\code{\link{restore}} to apply a snapshot.
\code{\link{status}} to view the differences between the most recent snapshot
and the library.
}

