% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{violins}
\alias{violins}
\title{Wrapper around viol() to conveniently plot multiple violins on a single plot, analogous to the behavior of boxplot()}
\usage{
violins(
  x,
  data = NULL,
  group = NULL,
  horiz = FALSE,
  order = NULL,
  xlab = "",
  ylab = "",
  col = "black",
  fill = "grey",
  lwd = 1,
  lty = 1,
  dscale = 1,
  xlim = NULL,
  ylim = NULL,
  spaces = "_",
  add = FALSE,
  ax = TRUE,
  srt = 45,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{x}{plotting statistic (numeric vector) or formula object from which a plotting statistic and grouping variable can be extracted (i.e. of form x~group)}

\item{data}{data.frame object containing x and y}

\item{group}{grouping variable}

\item{horiz}{logical indicating whether to plot horizontally}

\item{order}{order of factor levels of categorical factor}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{col}{vector of border colors}

\item{fill}{vector of fill colors}

\item{lwd}{vector of line widths}

\item{lty}{vector of line types}

\item{dscale}{density scaling factors (numeric) to apply to individual violins}

\item{xlim}{x limits (data limits used if NULL)}

\item{ylim}{y limits (data limits used if NULL)}

\item{spaces}{character string in group to replace with spaces for labels, if not NULL}

\item{add}{logical whether to add to existing plot (default: FALSE)}

\item{ax}{whether to plot axes}

\item{srt}{angle for categorical axis text rotation}

\item{na.rm}{logical indicating whether to tell viol() to remove NA values (defaults to TRUE)}

\item{...}{other arguments to pass on to paleoDiv::viol() and plot()}
}
\description{
Wrapper around viol() to conveniently plot multiple violins on a single plot, analogous to the behavior of boxplot()
}
\examples{
data.frame(p=rnorm(50), cat=rep(c("A","B","B","B","B"),10))->d
violins(p~cat,d)
}
