% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{sim.Stasis.RW}
\alias{sim.Stasis.RW}
\title{Simulate trait evolution with a mode shift}
\usage{
sim.Stasis.RW(ns = c(20, 20), order = c("Stasis-RW", "RW-Stasis"),
  anc = 0, omega = 1, ms = 0, vs = 1, vp = 1, nn = 30,
  tt = NULL)
}
\arguments{
\item{ns}{vector of the number of samples in each segment}

\item{order}{whether stasis or random walk come first, one of \code{"Stasis-RW"} or
\code{"RW-Stasis"}}

\item{anc}{starting trait value}

\item{omega}{variance of stasis segment}

\item{ms}{step mean during random walk segment}

\item{vs}{step variance during random walk segment}

\item{vp}{phenotypic trait variance for each population}

\item{nn}{vector of sample sizes for each population}

\item{tt}{vector of times (ages) for each population}
}
\value{
a \code{paleoTSfit} object
}
\description{
Trait evolution is modeled as a shift from a random walk (general or unbiased)
to stasis, or vice versa.
}
\details{
The \code{anc} argument is the starting trait value, and if the
first segment is stasis, this is also the value of the stasis mean. When the first segment
is a random walk, the stasis mean in the second segment is equal to the true trait mean at
the end of the initial random walk.
}
\examples{
x1 <- sim.Stasis.RW(omega = 0.1, ms = 5, order = "Stasis-RW")
x2 <- sim.Stasis.RW(omega = 0.1, ms = 5, order = "RW-Stasis")
plot(x1)
plot(x2, add = TRUE, col = "blue")
abline(v = 19, lty=3)

}
\seealso{
\code{\link{fitModeShift}}
}
