% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{test.var.het}
\alias{test.var.het}
\title{Test for heterogeneity of variances among samples in a time-series}
\usage{
test.var.het(y, method = "Bartlett")
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{method}{test to use; currently only \code{"Bartlett"} is implemented}
}
\value{
a list with the test statistic, degrees of freedom, and p-value
}
\description{
Test for heterogeneity of variances among samples in a time-series
}
\note{
Most often, this function will be used to assess if it is reasonable to
pool variances across samples using \code{pool.var}. A significant result means
that the null hypothesis of equal variances across samples is rejected.  Even in
this case, however, it may still be preferable to pool variances, at least for
some populations, if sample sizes are quite low.
}
\examples{
data(cantius_L)
test.var.het(cantius_L)  # significant, but still may want to pool variances
}
\references{
Sokal, R. R and F. J. Rohlf.  1995. \emph{Biometry} 3rd Ed.
}
\seealso{
\code{\link{pool.var}}
}
