% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_lmer.R
\name{tidy.wbm}
\alias{tidy.wbm}
\alias{glance.wbm}
\title{Tidy methods for \code{wbm} models}
\usage{
tidy.wbm(x, conf.int = FALSE, conf.level = 0.95, effects = c("fixed",
  "ran_pars"), conf.method = "Wald", ran_prefix = NULL, ...)

glance.wbm(x, ...)
}
\arguments{
\item{x}{An object of class \code{merMod}, such as those from \code{lmer},
\code{glmer}, or \code{nlmer}}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{effects}{A character vector including one or more of "fixed" (fixed-effect parameters), "ran_pars" (variances and covariances or standard deviations and correlations of random effect terms) or "ran_modes" (conditional modes/BLUPs/latent variable estimates)}

\item{conf.method}{method for computing confidence intervals (see \code{lme4::confint.merMod})}

\item{ran_prefix}{a length-2 character vector specifying the strings to use as prefixes for self- (variance/standard deviation) and cross- (covariance/correlation) random effects terms}

\item{...}{extra arguments (not used)}
}
\description{
\code{panelr} provides methods to access \code{wbm} data in a tidy format
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- wbm(lwage ~ lag(union) + wks, data = wages)
if (requireNamespace("broom")) {
  broom::tidy(model)
}
}
