% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dof_kenward.R, R/p_value_kenward.R,
%   R/se_kenward.R
\name{dof_kenward}
\alias{dof_kenward}
\alias{p_value_kenward}
\alias{se_kenward}
\title{p-values using Kenward-Roger approximation}
\usage{
dof_kenward(model)

p_value_kenward(model, dof = NULL)

se_kenward(model)
}
\arguments{
\item{model}{A statistical model.}

\item{dof}{Degrees of Freedom.}
}
\value{
The p-values.
}
\description{
An approximate F-test based on the Kenward-Roger (1997) approach.
}
\details{
\code{dof_kenward()} and \code{se_kenward()} are small helper-functions
to calculate approximated degrees of freedom and standard errors for model
parameters, based on the Kenward-Roger (1997) approach.
}
\examples{
\donttest{
library(lme4)
model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
p_value_kenward(model)
}

}
\references{
Kenward, M. G., & Roger, J. H. (1997). Small sample inference for fixed effects from restricted maximum likelihood. Biometrics, 983-997.
}
