% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_parameters.R
\name{ICA}
\alias{ICA}
\title{Independent Component Analysis (ICA)}
\usage{
ICA(x, n = "all", ...)
}
\arguments{
\item{x}{A dataframe or a statistical model.}

\item{n}{Number of components to extract. If \code{n="all"}, then \code{n} is set as the number of variables minus 1 (\code{ncol(x)-1}). If \code{n="auto"} (default) or \code{n=NULL}, the number of components is selected through \code{\link{n_factors}}. In \code{\link{reduce_parameters}}, can also be \code{"max"}, in which case it will select all the components that are maximally pseudo-loaded (i.e., correlated) by at least one variable.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Performs an Independent Component Analysis using the FastICA algorithm. Contrary to PCA, that attempts to find uncorrelated sources (through least squares minimization), ICA attempts to find independent sources, i.e., the source space that maximizes the "non-gaussianity" of all sources. Contrary to PCA, ICA does not rank each source, which makes it a poor tool for dimensionality reduction. Requires the \pkg{fastICA} package to be installed.
}
\examples{
ICA(iris[, 1:4])
}
