% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_parameters.R
\name{format_parameters}
\alias{format_parameters}
\title{Parameter names formatting}
\usage{
format_parameters(model)
}
\arguments{
\item{model}{A statistical model.}
}
\value{
The formatted parameter names.
}
\description{
Parameter names formatting
}
\examples{
library(parameters)

model <- lm(Sepal.Length ~ Species * Sepal.Width, data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Species / Petal.Length, data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Petal.Length + (Species / Sepal.Width), data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Species + poly(Sepal.Width, 2), data = iris)
format_parameters(model)

model <- lm(Sepal.Length ~ Species + poly(Sepal.Width, 2, raw = TRUE), data = iris)
format_parameters(model)
}
