% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{adjustedRandIndex}
\alias{adjustedRandIndex}
\alias{adjustedRandIndex,Partition,Partition-method}
\alias{adjustedRandIndex,PairCoefficients,missing-method}
\title{Adjusted Rand Index}
\usage{
adjustedRandIndex(p, q)

\S4method{adjustedRandIndex}{Partition,Partition}(p, q)

\S4method{adjustedRandIndex}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Adjusted Rand Index (ARI)
\deqn{\frac{2(N_{00}N_{11} - N_{10}N_{01})}{N'_{01}N_{12} + N'_{10}N_{21}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
isTRUE(all.equal(adjustedRandIndex(new("Partition", c(0, 0, 0, 1, 1)), 
                                   new("Partition", c(0, 0, 1, 1, 1))), 1/6))

}
\references{
\insertRef{Hubert1985}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
