/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchAlgorithms;

import ActiveSubnetworkSearchAlgorithms.CrossoverType;
import ActiveSubnetworkSearchAlgorithms.GAIndividual;
import ActiveSubnetworkSearchAlgorithms.SelectionType;
import Application.Parameters;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;

class NewPopulationFactory
implements Runnable {
    ArrayList<GAIndividual> newPopulation;
    ArrayList<GAIndividual> population;
    SelectionType selectionType;
    CrossoverType crossoverType;

    public NewPopulationFactory(ArrayList<GAIndividual> population, ArrayList<GAIndividual> newPopulation, SelectionType selectionType, CrossoverType crossoverType) {
        this.population = population;
        this.newPopulation = newPopulation;
        this.selectionType = selectionType;
        this.crossoverType = crossoverType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.newPopulation.size() < this.population.size()) {
            GAIndividual[] parents = this.selection(this.population);
            GAIndividual[] offsprings = this.crossoverAndMutation(parents[0], parents[1]);
            ArrayList<GAIndividual> arrayList = this.newPopulation;
            synchronized (arrayList) {
                if (this.newPopulation.size() < this.population.size()) {
                    for (int i = 0; i < offsprings.length; ++i) {
                        this.newPopulation.add(offsprings[i]);
                    }
                }
            }
        }
    }

    private GAIndividual[] selection(ArrayList<GAIndividual> population) {
        int i;
        double totalWeight = 0.0;
        double[] weights = new double[population.size()];
        if (this.selectionType == SelectionType.RANKSELECTION) {
            for (i = 0; i < population.size(); ++i) {
                weights[i] = population.size() - i;
                totalWeight += weights[i];
            }
        } else {
            for (i = 0; i < population.size(); ++i) {
                weights[i] = population.get(i).getScore();
                totalWeight += weights[i];
            }
        }
        GAIndividual[] parents = new GAIndividual[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            int randomIndex = -1;
            double rand = ThreadLocalRandom.current().nextDouble() * totalWeight;
            for (int rr = 0; rr < population.size() && randomIndex == -1; ++rr) {
                if (!((rand -= weights[rr]) <= 0.0)) continue;
                randomIndex = rr;
            }
            parents[i2] = population.get(randomIndex);
        }
        return parents;
    }

    private GAIndividual[] crossoverAndMutation(GAIndividual parent1, GAIndividual parent2) {
        int i;
        ArrayList<Boolean> parent1Boolean = parent1.getRepresentationBoolean();
        ArrayList<Boolean> parent2Boolean = parent2.getRepresentationBoolean();
        ArrayList<Boolean> child1Boolean = new ArrayList<Boolean>();
        ArrayList<Boolean> child2Boolean = new ArrayList<Boolean>();
        if (this.crossoverType == CrossoverType.SINGLEPOINT) {
            int i2;
            int crossoverPoint = ThreadLocalRandom.current().nextInt(parent1Boolean.size());
            for (i2 = 0; i2 < crossoverPoint; ++i2) {
                child1Boolean.add(parent1Boolean.get(i2));
                child2Boolean.add(parent2Boolean.get(i2));
            }
            for (i2 = crossoverPoint; i2 < parent1Boolean.size(); ++i2) {
                child1Boolean.add(parent2Boolean.get(i2));
                child2Boolean.add(parent1Boolean.get(i2));
            }
        } else if (this.crossoverType == CrossoverType.MULTIPOINT) {
            int flag = 0;
            int count = 0;
            for (int i3 = 0; i3 < parent1Boolean.size(); ++i3) {
                if (flag == 0) {
                    child1Boolean.add(parent1Boolean.get(i3));
                    child2Boolean.add(parent2Boolean.get(i3));
                } else {
                    child1Boolean.add(parent2Boolean.get(i3));
                    child2Boolean.add(parent1Boolean.get(i3));
                }
                if (++count != 10) continue;
                count = 0;
                flag = (flag + 1) % 2;
            }
        } else {
            for (i = 0; i < parent1Boolean.size(); ++i) {
                if (ThreadLocalRandom.current().nextBoolean()) {
                    child1Boolean.add(parent1Boolean.get(i));
                    child2Boolean.add(parent2Boolean.get(i));
                    continue;
                }
                child1Boolean.add(parent2Boolean.get(i));
                child2Boolean.add(parent1Boolean.get(i));
            }
        }
        if (Parameters.ga_mutation) {
            for (i = 0; i < child1Boolean.size(); ++i) {
                if (ThreadLocalRandom.current().nextDouble() < Parameters.ga_mutationRate) {
                    child1Boolean.set(i, child1Boolean.get(i) == false);
                }
                if (!(ThreadLocalRandom.current().nextDouble() < Parameters.ga_mutationRate)) continue;
                child2Boolean.set(i, child2Boolean.get(i) == false);
            }
        }
        GAIndividual[] offsprings = new GAIndividual[]{new GAIndividual(child1Boolean), new GAIndividual(child2Boolean)};
        return offsprings;
    }
}

