% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_platform_application_attributes}
\alias{sns_set_platform_application_attributes}
\title{Sets the attributes of the platform application object for the supported
push notification services, such as APNS and GCM}
\usage{
sns_set_platform_application_attributes(PlatformApplicationArn,
  Attributes)
}
\arguments{
\item{PlatformApplicationArn}{[required] PlatformApplicationArn for SetPlatformApplicationAttributes action.}

\item{Attributes}{[required] A map of the platform application attributes. Attributes in this map
include the following:
\itemize{
\item \code{PlatformCredential} -- The credential received from the
notification service. For APNS/APNS\_SANDBOX, PlatformCredential is
private key. For GCM, PlatformCredential is "API key". For ADM,
PlatformCredential is "client secret".
\item \code{PlatformPrincipal} -- The principal received from the notification
service. For APNS/APNS\_SANDBOX, PlatformPrincipal is SSL
certificate. For GCM, PlatformPrincipal is not applicable. For ADM,
PlatformPrincipal is "client id".
\item \code{EventEndpointCreated} -- Topic ARN to which EndpointCreated event
notifications should be sent.
\item \code{EventEndpointDeleted} -- Topic ARN to which EndpointDeleted event
notifications should be sent.
\item \code{EventEndpointUpdated} -- Topic ARN to which EndpointUpdate event
notifications should be sent.
\item \code{EventDeliveryFailure} -- Topic ARN to which DeliveryFailure event
notifications should be sent upon Direct Publish delivery failure
(permanent) to one of the application's endpoints.
\item \code{SuccessFeedbackRoleArn} -- IAM role ARN used to give Amazon SNS
write access to use CloudWatch Logs on your behalf.
\item \code{FailureFeedbackRoleArn} -- IAM role ARN used to give Amazon SNS
write access to use CloudWatch Logs on your behalf.
\item \code{SuccessFeedbackSampleRate} -- Sample rate percentage (0-100) of
successfully delivered messages.
}}
}
\description{
Sets the attributes of the platform application object for the supported
push notification services, such as APNS and GCM. For more information,
see \href{http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html}{Using Amazon SNS Mobile Push Notifications}.
For information on configuring attributes for message delivery status,
see \href{http://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html}{Using Amazon SNS Application Attributes for Message Delivery Status}.
}
\section{Request syntax}{
\preformatted{svc$set_platform_application_attributes(
  PlatformApplicationArn = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
