% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_delete_state_machine}
\alias{sfn_delete_state_machine}
\title{Deletes a state machine}
\usage{
sfn_delete_state_machine(stateMachineArn)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine to delete.}
}
\description{
Deletes a state machine. This is an asynchronous operation: It sets the
state machine's status to \code{DELETING} and begins the deletion process.

For \code{EXPRESS}state machines, the deletion will happen eventually
(usually less than a minute). Running executions may emit logs after
\code{DeleteStateMachine} API is called.
}
\section{Request syntax}{
\preformatted{svc$delete_state_machine(
  stateMachineArn = "string"
)
}
}

\keyword{internal}
