% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_traffic_mirror_session}
\alias{ec2_create_traffic_mirror_session}
\title{Creates a Traffic Mirror session}
\usage{
ec2_create_traffic_mirror_session(NetworkInterfaceId,
  TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength,
  SessionNumber, VirtualNetworkId, Description, TagSpecifications, DryRun,
  ClientToken)
}
\arguments{
\item{NetworkInterfaceId}{[required] The ID of the source network interface.}

\item{TrafficMirrorTargetId}{[required] The ID of the Traffic Mirror target.}

\item{TrafficMirrorFilterId}{[required] The ID of the Traffic Mirror filter.}

\item{PacketLength}{The number of bytes in each packet to mirror. These are bytes after the
VXLAN header. Do not specify this parameter when you want to mirror the
entire packet. To mirror a subset of the packet, set this to the length
(in bytes) that you want to mirror. For example, if you set this value
to 1network0, then the first 100 bytes that meet the filter criteria are
copied to the target.

If you do not want to mirror the entire packet, use the \code{PacketLength}
parameter to specify the number of bytes in each packet to mirror.}

\item{SessionNumber}{[required] The session number determines the order in which sessions are evaluated
when an interface is used by multiple sessions. The first session with a
matching filter is the one that mirrors the packets.

Valid values are 1-32766.}

\item{VirtualNetworkId}{The VXLAN ID for the Traffic Mirror session. For more information about
the VXLAN protocol, see \href{https://tools.ietf.org/html/rfc7348}{RFC 7348}.
If you do not specify a \code{VirtualNetworkId}, an account-wide unique id is
chosen at random.}

\item{Description}{The description of the Traffic Mirror session.}

\item{TagSpecifications}{The tags to assign to a Traffic Mirror session.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}
}
\description{
Creates a Traffic Mirror session.
}
\details{
A Traffic Mirror session actively copies packets from a Traffic Mirror
source to a Traffic Mirror target. Create a filter, and then assign it
to the session to define a subset of the traffic to mirror, for example
all TCP traffic.

The Traffic Mirror source and the Traffic Mirror target (monitoring
appliances) can be in the same VPC, or in a different VPC connected via
VPC peering or a transit gateway.

By default, no traffic is mirrored. Use CreateTrafficMirrorFilter to
create filter rules that specify the traffic to mirror.
}
\section{Request syntax}{
\preformatted{svc$create_traffic_mirror_session(
  NetworkInterfaceId = "string",
  TrafficMirrorTargetId = "string",
  TrafficMirrorFilterId = "string",
  PacketLength = 123,
  SessionNumber = 123,
  VirtualNetworkId = 123,
  Description = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE,
  ClientToken = "string"
)
}
}

\keyword{internal}
