% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_request_spot_fleet}
\alias{ec2_request_spot_fleet}
\title{Creates a Spot Fleet request}
\usage{
ec2_request_spot_fleet(DryRun, SpotFleetRequestConfig)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SpotFleetRequestConfig}{[required] The configuration for the Spot Fleet request.}
}
\description{
Creates a Spot Fleet request.
}
\details{
The Spot Fleet request specifies the total target capacity and the
On-Demand target capacity. Amazon EC2 calculates the difference between
the total capacity and On-Demand capacity, and launches the difference
as Spot capacity.

You can submit a single request that includes multiple launch
specifications that vary by instance type, AMI, Availability Zone, or
subnet.

By default, the Spot Fleet requests Spot Instances in the Spot pool
where the price per unit is the lowest. Each launch specification can
include its own instance weighting that reflects the value of the
instance type to your application workload.

Alternatively, you can specify that the Spot Fleet distribute the target
capacity across the Spot pools included in its launch specifications. By
ensuring that the Spot Instances in your Spot Fleet are in different
Spot pools, you can improve the availability of your fleet.

You can specify tags for the Spot Instances. You cannot tag other
resource types in a Spot Fleet request because only the \code{instance}
resource type is supported.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html}{Spot Fleet Requests}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
}
\section{Request syntax}{
\preformatted{svc$request_spot_fleet(
  DryRun = TRUE|FALSE,
  SpotFleetRequestConfig = list(
    AllocationStrategy = "lowestPrice"|"diversified",
    OnDemandAllocationStrategy = "lowestPrice"|"prioritized",
    ClientToken = "string",
    ExcessCapacityTerminationPolicy = "noTermination"|"default",
    FulfilledCapacity = 123.0,
    OnDemandFulfilledCapacity = 123.0,
    IamFleetRole = "string",
    LaunchSpecifications = list(
      list(
        SecurityGroups = list(
          list(
            GroupName = "string",
            GroupId = "string"
          )
        ),
        AddressingType = "string",
        BlockDeviceMappings = list(
          list(
            DeviceName = "string",
            VirtualName = "string",
            Ebs = list(
              DeleteOnTermination = TRUE|FALSE,
              Iops = 123,
              SnapshotId = "string",
              VolumeSize = 123,
              VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1",
              Encrypted = TRUE|FALSE,
              KmsKeyId = "string"
            ),
            NoDevice = "string"
          )
        ),
        EbsOptimized = TRUE|FALSE,
        IamInstanceProfile = list(
          Arn = "string",
          Name = "string"
        ),
        ImageId = "string",
        InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.18xlarge"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge",
        KernelId = "string",
        KeyName = "string",
        Monitoring = list(
          Enabled = TRUE|FALSE
        ),
        NetworkInterfaces = list(
          list(
            AssociatePublicIpAddress = TRUE|FALSE,
            DeleteOnTermination = TRUE|FALSE,
            Description = "string",
            DeviceIndex = 123,
            Groups = list(
              "string"
            ),
            Ipv6AddressCount = 123,
            Ipv6Addresses = list(
              list(
                Ipv6Address = "string"
              )
            ),
            NetworkInterfaceId = "string",
            PrivateIpAddress = "string",
            PrivateIpAddresses = list(
              list(
                Primary = TRUE|FALSE,
                PrivateIpAddress = "string"
              )
            ),
            SecondaryPrivateIpAddressCount = 123,
            SubnetId = "string",
            InterfaceType = "string"
          )
        ),
        Placement = list(
          AvailabilityZone = "string",
          GroupName = "string",
          Tenancy = "default"|"dedicated"|"host"
        ),
        RamdiskId = "string",
        SpotPrice = "string",
        SubnetId = "string",
        UserData = "string",
        WeightedCapacity = 123.0,
        TagSpecifications = list(
          list(
            ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          )
        )
      )
    ),
    LaunchTemplateConfigs = list(
      list(
        LaunchTemplateSpecification = list(
          LaunchTemplateId = "string",
          LaunchTemplateName = "string",
          Version = "string"
        ),
        Overrides = list(
          list(
            InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.18xlarge"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge",
            SpotPrice = "string",
            SubnetId = "string",
            AvailabilityZone = "string",
            WeightedCapacity = 123.0,
            Priority = 123.0
          )
        )
      )
    ),
    SpotPrice = "string",
    TargetCapacity = 123,
    OnDemandTargetCapacity = 123,
    OnDemandMaxTotalPrice = "string",
    SpotMaxTotalPrice = "string",
    TerminateInstancesWithExpiration = TRUE|FALSE,
    Type = "request"|"maintain"|"instant",
    ValidFrom = as.POSIXct(
      "2015-01-01"
    ),
    ValidUntil = as.POSIXct(
      "2015-01-01"
    ),
    ReplaceUnhealthyInstances = TRUE|FALSE,
    InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate",
    LoadBalancersConfig = list(
      ClassicLoadBalancersConfig = list(
        ClassicLoadBalancers = list(
          list(
            Name = "string"
          )
        )
      ),
      TargetGroupsConfig = list(
        TargetGroups = list(
          list(
            Arn = "string"
          )
        )
      )
    ),
    InstancePoolsToUseCount = 123
  )
)
}
}

\examples{
# This example creates a Spot fleet request with two launch specifications
# that differ only by subnet. The Spot fleet launches the instances in the
# specified subnet with the lowest price. If the instances are launched in
# a default VPC, they receive a public IP address by default. If the
# instances are launched in a nondefault VPC, they do not receive a public
# IP address by default. Note that you can't specify different subnets
# from the same Availability Zone in a Spot fleet request.
\donttest{svc$request_spot_fleet(
  SpotFleetRequestConfig = list(
    IamFleetRole = "arn:aws:iam::123456789012:role/my-spot-fleet-role",
    LaunchSpecifications = list(
      list(
        IamInstanceProfile = list(
          Arn = "arn:aws:iam::123456789012:instance-profile/my-iam-role"
        ),
        ImageId = "ami-1a2b3c4d",
        InstanceType = "m3.medium",
        KeyName = "my-key-pair",
        SecurityGroups = list(
          list(
            GroupId = "sg-1a2b3c4d"
          )
        ),
        SubnetId = "subnet-1a2b3c4d, subnet-3c4d5e6f"
      )
    ),
    SpotPrice = "0.04",
    TargetCapacity = 2L
  )
)}

# This example creates a Spot fleet request with two launch specifications
# that differ only by Availability Zone. The Spot fleet launches the
# instances in the specified Availability Zone with the lowest price. If
# your account supports EC2-VPC only, Amazon EC2 launches the Spot
# instances in the default subnet of the Availability Zone. If your
# account supports EC2-Classic, Amazon EC2 launches the instances in
# EC2-Classic in the Availability Zone.
\donttest{svc$request_spot_fleet(
  SpotFleetRequestConfig = list(
    IamFleetRole = "arn:aws:iam::123456789012:role/my-spot-fleet-role",
    LaunchSpecifications = list(
      list(
        IamInstanceProfile = list(
          Arn = "arn:aws:iam::123456789012:instance-profile/my-iam-role"
        ),
        ImageId = "ami-1a2b3c4d",
        InstanceType = "m3.medium",
        KeyName = "my-key-pair",
        Placement = list(
          AvailabilityZone = "us-west-2a, us-west-2b"
        ),
        SecurityGroups = list(
          list(
            GroupId = "sg-1a2b3c4d"
          )
        )
      )
    ),
    SpotPrice = "0.04",
    TargetCapacity = 2L
  )
)}

# This example assigns public addresses to instances launched in a
# nondefault VPC. Note that when you specify a network interface, you must
# include the subnet ID and security group ID using the network interface.
\donttest{svc$request_spot_fleet(
  SpotFleetRequestConfig = list(
    IamFleetRole = "arn:aws:iam::123456789012:role/my-spot-fleet-role",
    LaunchSpecifications = list(
      list(
        IamInstanceProfile = list(
          Arn = "arn:aws:iam::880185128111:instance-profile/my-iam-role"
        ),
        ImageId = "ami-1a2b3c4d",
        InstanceType = "m3.medium",
        KeyName = "my-key-pair",
        NetworkInterfaces = list(
          list(
            AssociatePublicIpAddress = TRUE,
            DeviceIndex = 0L,
            Groups = list(
              "sg-1a2b3c4d"
            ),
            SubnetId = "subnet-1a2b3c4d"
          )
        )
      )
    ),
    SpotPrice = "0.04",
    TargetCapacity = 2L
  )
)}

# This example creates a Spot fleet request that launches 30 instances
# using the diversified allocation strategy. The launch specifications
# differ by instance type. The Spot fleet distributes the instances across
# the launch specifications such that there are 10 instances of each type.
\donttest{svc$request_spot_fleet(
  SpotFleetRequestConfig = list(
    AllocationStrategy = "diversified",
    IamFleetRole = "arn:aws:iam::123456789012:role/my-spot-fleet-role",
    LaunchSpecifications = list(
      list(
        ImageId = "ami-1a2b3c4d",
        InstanceType = "c4.2xlarge",
        SubnetId = "subnet-1a2b3c4d"
      ),
      list(
        ImageId = "ami-1a2b3c4d",
        InstanceType = "m3.2xlarge",
        SubnetId = "subnet-1a2b3c4d"
      ),
      list(
        ImageId = "ami-1a2b3c4d",
        InstanceType = "r3.2xlarge",
        SubnetId = "subnet-1a2b3c4d"
      )
    ),
    SpotPrice = "0.70",
    TargetCapacity = 30L
  )
)}

}
\keyword{internal}
