% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_create_repository}
\alias{ecr_create_repository}
\title{Creates an image repository}
\usage{
ecr_create_repository(repositoryName, tags)
}
\arguments{
\item{repositoryName}{[required] The name to use for the repository. The repository name may be specified
on its own (such as \code{nginx-web-app}) or it can be prepended with a
namespace to group the repository into a category (such as
\code{project-a/nginx-web-app}).}

\item{tags}{}
}
\description{
Creates an image repository.
}
\section{Request syntax}{
\preformatted{svc$create_repository(
  repositoryName = "string",
  tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# This example creates a repository called nginx-web-app inside the
# project-a namespace in the default registry for an account.
\donttest{svc$create_repository(
  repositoryName = "project-a/nginx-web-app"
)}

}
\keyword{internal}
