% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_instances_from_snapshot}
\alias{lightsail_create_instances_from_snapshot}
\title{Uses a specific snapshot as a blueprint for creating one or more new
instances that are based on that identical configuration}
\usage{
lightsail_create_instances_from_snapshot(instanceNames,
  attachedDiskMapping, availabilityZone, instanceSnapshotName, bundleId,
  userData, keyPairName, tags)
}
\arguments{
\item{instanceNames}{[required] The names for your new instances.}

\item{attachedDiskMapping}{An object containing information about one or more disk mappings.}

\item{availabilityZone}{[required] The Availability Zone where you want to create your instances. Use the
following formatting: \code{us-east-2a} (case sensitive). You can get a list
of Availability Zones by using the \href{http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html}{get regions}
operation. Be sure to add the \code{include Availability Zones} parameter to
your request.}

\item{instanceSnapshotName}{[required] The name of the instance snapshot on which you are basing your new
instances. Use the get instance snapshots operation to return
information about your existing snapshots.}

\item{bundleId}{[required] The bundle of specification information for your virtual private server
(or \emph{instance}), including the pricing plan (e.g., \code{micro_1_0}).}

\item{userData}{You can create a launch script that configures a server with additional
user data. For example, \code{apt-get -y update}.

Depending on the machine image you choose, the command to get software
on your instance varies. Amazon Linux and CentOS use \code{yum}, Debian and
Ubuntu use \code{apt-get}, and FreeBSD uses \code{pkg}. For a complete list, see
the \href{https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image}{Dev Guide}.}

\item{keyPairName}{The name for your key pair.}

\item{tags}{The tag keys and optional values to add to the resource during create.

To tag a resource after it has been created, see the \code{tag resource}
operation.}
}
\description{
Uses a specific snapshot as a blueprint for creating one or more new
instances that are based on that identical configuration.
}
\details{
The \code{create instances from snapshot} operation supports tag-based access
control via request tags and resource tags applied to the resource
identified by instanceSnapshotName. For more information, see the
\href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_instances_from_snapshot(
  instanceNames = list(
    "string"
  ),
  attachedDiskMapping = list(
    list(
      list(
        originalDiskPath = "string",
        newDiskName = "string"
      )
    )
  ),
  availabilityZone = "string",
  instanceSnapshotName = "string",
  bundleId = "string",
  userData = "string",
  keyPairName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
