% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_authorize_security_group_ingress}
\alias{ec2_authorize_security_group_ingress}
\title{Adds the specified inbound (ingress) rules to a security group}
\usage{
ec2_authorize_security_group_ingress(
  CidrIp = NULL,
  FromPort = NULL,
  GroupId = NULL,
  GroupName = NULL,
  IpPermissions = NULL,
  IpProtocol = NULL,
  SourceSecurityGroupName = NULL,
  SourceSecurityGroupOwnerId = NULL,
  ToPort = NULL,
  DryRun = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{CidrIp}{The IPv4 address range, in CIDR format. You can't specify this parameter
when specifying a source security group. To specify an IPv6 address
range, use a set of IP permissions.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{FromPort}{If the protocol is TCP or UDP, this is the start of the port range. If
the protocol is ICMP, this is the type number. A value of -1 indicates
all ICMP types. If you specify all ICMP types, you must specify all ICMP
codes.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You must
specify either the security group ID or the security group name in the
request. For security groups in a nondefault VPC, you must specify the
security group ID.}

\item{IpPermissions}{The sets of IP permissions.}

\item{IpProtocol}{The IP protocol name (\code{tcp}, \code{udp}, \code{icmp}) or number (see \href{http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml}{Protocol Numbers}).
To specify \code{icmpv6}, use a set of IP permissions.

[VPC only] Use \code{-1} to specify all protocols. If you specify \code{-1} or a
protocol other than \code{tcp}, \code{udp}, or \code{icmp}, traffic on all ports is
allowed, regardless of any ports you specify.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{SourceSecurityGroupName}{[EC2-Classic, default VPC] The name of the source security group. You
can't specify this parameter in combination with the following
parameters: the CIDR IP address range, the start of the port range, the
IP protocol, and the end of the port range. Creates rules that grant
full ICMP, UDP, and TCP access. To create a rule with a specific IP
protocol and port range, use a set of IP permissions instead. For
EC2-VPC, the source security group must be in the same VPC.}

\item{SourceSecurityGroupOwnerId}{[nondefault VPC] The Amazon Web Services account ID for the source
security group, if the source security group is in a different account.
You can't specify this parameter in combination with the following
parameters: the CIDR IP address range, the IP protocol, the start of the
port range, and the end of the port range. Creates rules that grant full
ICMP, UDP, and TCP access. To create a rule with a specific IP protocol
and port range, use a set of IP permissions instead.}

\item{ToPort}{If the protocol is TCP or UDP, this is the end of the port range. If the
protocol is ICMP, this is the code. A value of -1 indicates all ICMP
codes. If you specify all ICMP types, you must specify all ICMP codes.

Alternatively, use a set of IP permissions to specify multiple rules and
a description for the rule.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{[VPC Only] The tags applied to the security group rule.}
}
\description{
Adds the specified inbound (ingress) rules to a security group.

See \url{https://www.paws-r-sdk.com/docs/ec2_authorize_security_group_ingress/} for full documentation.
}
\keyword{internal}
