% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_network_acls}
\alias{ec2_describe_network_acls}
\title{Describes one or more of your network ACLs}
\usage{
ec2_describe_network_acls(
  Filters = NULL,
  DryRun = NULL,
  NetworkAclIds = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{association.association-id} - The ID of an association ID for the
ACL.
\item \code{association.network-acl-id} - The ID of the network ACL involved in
the association.
\item \code{association.subnet-id} - The ID of the subnet involved in the
association.
\item \code{default} - Indicates whether the ACL is the default network ACL for
the VPC.
\item \code{entry.cidr} - The IPv4 CIDR range specified in the entry.
\item \code{entry.icmp.code} - The ICMP code specified in the entry, if any.
\item \code{entry.icmp.type} - The ICMP type specified in the entry, if any.
\item \code{entry.ipv6-cidr} - The IPv6 CIDR range specified in the entry.
\item \code{entry.port-range.from} - The start of the port range specified in
the entry.
\item \code{entry.port-range.to} - The end of the port range specified in the
entry.
\item \code{entry.protocol} - The protocol specified in the entry (\code{tcp} |
\code{udp} | \code{icmp} or a protocol number).
\item \code{entry.rule-action} - Allows or denies the matching traffic (\code{allow}
| \code{deny}).
\item \code{entry.egress} - A Boolean that indicates the type of rule. Specify
\code{true} for egress rules, or \code{false} for ingress rules.
\item \code{entry.rule-number} - The number of an entry (in other words, rule)
in the set of ACL entries.
\item \code{network-acl-id} - The ID of the network ACL.
\item \code{owner-id} - The ID of the Amazon Web Services account that owns the
network ACL.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC for the network ACL.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NetworkAclIds}{One or more network ACL IDs.

Default: Describes all your network ACLs.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes one or more of your network ACLs.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_network_acls/} for full documentation.
}
\keyword{internal}
