# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include pinpoint_service.R
NULL

#' Creates or updates an app
#'
#' Creates or updates an app.
#'
#' @usage
#' pinpoint_create_app(CreateApplicationRequest)
#'
#' @param CreateApplicationRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_app(
#'   CreateApplicationRequest = list(
#'     Name = "string",
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_app
pinpoint_create_app <- function(CreateApplicationRequest) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/v1/apps",
    paginator = list()
  )
  input <- .pinpoint$create_app_input(CreateApplicationRequest = CreateApplicationRequest)
  output <- .pinpoint$create_app_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_app <- pinpoint_create_app

#' Creates or updates a campaign
#'
#' Creates or updates a campaign.
#'
#' @usage
#' pinpoint_create_campaign(ApplicationId, WriteCampaignRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param WriteCampaignRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_campaign(
#'   ApplicationId = "string",
#'   WriteCampaignRequest = list(
#'     AdditionalTreatments = list(
#'       list(
#'         MessageConfiguration = list(
#'           ADMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           APNSMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           BaiduMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           DefaultMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           EmailMessage = list(
#'             Body = "string",
#'             FromAddress = "string",
#'             HtmlBody = "string",
#'             Title = "string"
#'           ),
#'           GCMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           SMSMessage = list(
#'             Body = "string",
#'             MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'             SenderId = "string"
#'           )
#'         ),
#'         Schedule = list(
#'           EndTime = "string",
#'           EventFilter = list(
#'             Dimensions = list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               EventType = list(
#'                 DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                 Values = list(
#'                   "string"
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               )
#'             ),
#'             FilterType = "SYSTEM"|"ENDPOINT"
#'           ),
#'           Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'           IsLocalTime = TRUE|FALSE,
#'           QuietTime = list(
#'             End = "string",
#'             Start = "string"
#'           ),
#'           StartTime = "string",
#'           Timezone = "string"
#'         ),
#'         SizePercent = 123,
#'         TreatmentDescription = "string",
#'         TreatmentName = "string"
#'       )
#'     ),
#'     Description = "string",
#'     HoldoutPercent = 123,
#'     Hook = list(
#'       LambdaFunctionName = "string",
#'       Mode = "DELIVERY"|"FILTER",
#'       WebUrl = "string"
#'     ),
#'     IsPaused = TRUE|FALSE,
#'     Limits = list(
#'       Daily = 123,
#'       MaximumDuration = 123,
#'       MessagesPerSecond = 123,
#'       Total = 123
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FromAddress = "string",
#'         HtmlBody = "string",
#'         Title = "string"
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         SenderId = "string"
#'       )
#'     ),
#'     Name = "string",
#'     Schedule = list(
#'       EndTime = "string",
#'       EventFilter = list(
#'         Dimensions = list(
#'           Attributes = list(
#'             list(
#'               AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           EventType = list(
#'             DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'             Values = list(
#'               "string"
#'             )
#'           ),
#'           Metrics = list(
#'             list(
#'               ComparisonOperator = "string",
#'               Value = 123.0
#'             )
#'           )
#'         ),
#'         FilterType = "SYSTEM"|"ENDPOINT"
#'       ),
#'       Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'       IsLocalTime = TRUE|FALSE,
#'       QuietTime = list(
#'         End = "string",
#'         Start = "string"
#'       ),
#'       StartTime = "string",
#'       Timezone = "string"
#'     ),
#'     SegmentId = "string",
#'     SegmentVersion = 123,
#'     tags = list(
#'       "string"
#'     ),
#'     TreatmentDescription = "string",
#'     TreatmentName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_campaign
pinpoint_create_campaign <- function(ApplicationId, WriteCampaignRequest) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/campaigns",
    paginator = list()
  )
  input <- .pinpoint$create_campaign_input(ApplicationId = ApplicationId, WriteCampaignRequest = WriteCampaignRequest)
  output <- .pinpoint$create_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_campaign <- pinpoint_create_campaign

#' Creates an export job
#'
#' Creates an export job.
#'
#' @usage
#' pinpoint_create_export_job(ApplicationId, ExportJobRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param ExportJobRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_export_job(
#'   ApplicationId = "string",
#'   ExportJobRequest = list(
#'     RoleArn = "string",
#'     S3UrlPrefix = "string",
#'     SegmentId = "string",
#'     SegmentVersion = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_export_job
pinpoint_create_export_job <- function(ApplicationId, ExportJobRequest) {
  op <- new_operation(
    name = "CreateExportJob",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$create_export_job_input(ApplicationId = ApplicationId, ExportJobRequest = ExportJobRequest)
  output <- .pinpoint$create_export_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_export_job <- pinpoint_create_export_job

#' Creates or updates an import job
#'
#' Creates or updates an import job.
#'
#' @usage
#' pinpoint_create_import_job(ApplicationId, ImportJobRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param ImportJobRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_import_job(
#'   ApplicationId = "string",
#'   ImportJobRequest = list(
#'     DefineSegment = TRUE|FALSE,
#'     ExternalId = "string",
#'     Format = "CSV"|"JSON",
#'     RegisterEndpoints = TRUE|FALSE,
#'     RoleArn = "string",
#'     S3Url = "string",
#'     SegmentId = "string",
#'     SegmentName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_import_job
pinpoint_create_import_job <- function(ApplicationId, ImportJobRequest) {
  op <- new_operation(
    name = "CreateImportJob",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$create_import_job_input(ApplicationId = ApplicationId, ImportJobRequest = ImportJobRequest)
  output <- .pinpoint$create_import_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_import_job <- pinpoint_create_import_job

#' Used to create or update a segment
#'
#' Used to create or update a segment.
#'
#' @usage
#' pinpoint_create_segment(ApplicationId, WriteSegmentRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param WriteSegmentRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_segment(
#'   ApplicationId = "string",
#'   WriteSegmentRequest = list(
#'     Dimensions = list(
#'       Attributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Behavior = list(
#'         Recency = list(
#'           Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'           RecencyType = "ACTIVE"|"INACTIVE"
#'         )
#'       ),
#'       Demographic = list(
#'         AppVersion = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Channel = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         DeviceType = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Make = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Model = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Platform = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = list(
#'         Country = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         GPSPoint = list(
#'           Coordinates = list(
#'             Latitude = 123.0,
#'             Longitude = 123.0
#'           ),
#'           RangeInKilometers = 123.0
#'         )
#'       ),
#'       Metrics = list(
#'         list(
#'           ComparisonOperator = "string",
#'           Value = 123.0
#'         )
#'       ),
#'       UserAttributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     Name = "string",
#'     SegmentGroups = list(
#'       Groups = list(
#'         list(
#'           Dimensions = list(
#'             list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Behavior = list(
#'                 Recency = list(
#'                   Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'                   RecencyType = "ACTIVE"|"INACTIVE"
#'                 )
#'               ),
#'               Demographic = list(
#'                 AppVersion = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Channel = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 DeviceType = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Make = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Model = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Platform = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Location = list(
#'                 Country = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 GPSPoint = list(
#'                   Coordinates = list(
#'                     Latitude = 123.0,
#'                     Longitude = 123.0
#'                   ),
#'                   RangeInKilometers = 123.0
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               ),
#'               UserAttributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           SourceSegments = list(
#'             list(
#'               Id = "string",
#'               Version = 123
#'             )
#'           ),
#'           SourceType = "ALL"|"ANY"|"NONE",
#'           Type = "ALL"|"ANY"|"NONE"
#'         )
#'       ),
#'       Include = "ALL"|"ANY"|"NONE"
#'     ),
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_segment
pinpoint_create_segment <- function(ApplicationId, WriteSegmentRequest) {
  op <- new_operation(
    name = "CreateSegment",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/segments",
    paginator = list()
  )
  input <- .pinpoint$create_segment_input(ApplicationId = ApplicationId, WriteSegmentRequest = WriteSegmentRequest)
  output <- .pinpoint$create_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_segment <- pinpoint_create_segment

#' Delete an ADM channel
#'
#' Delete an ADM channel.
#'
#' @usage
#' pinpoint_delete_adm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_adm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_adm_channel
pinpoint_delete_adm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteAdmChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$delete_adm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_adm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_adm_channel <- pinpoint_delete_adm_channel

#' Deletes the APNs channel for an app
#'
#' Deletes the APNs channel for an app.
#'
#' @usage
#' pinpoint_delete_apns_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_channel
pinpoint_delete_apns_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_channel <- pinpoint_delete_apns_channel

#' Delete an APNS sandbox channel
#'
#' Delete an APNS sandbox channel.
#'
#' @usage
#' pinpoint_delete_apns_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_sandbox_channel
pinpoint_delete_apns_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsSandboxChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_sandbox_channel <- pinpoint_delete_apns_sandbox_channel

#' Delete an APNS VoIP channel
#'
#' Delete an APNS VoIP channel
#'
#' @usage
#' pinpoint_delete_apns_voip_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_voip_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_voip_channel
pinpoint_delete_apns_voip_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsVoipChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_voip_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_voip_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_voip_channel <- pinpoint_delete_apns_voip_channel

#' Delete an APNS VoIP sandbox channel
#'
#' Delete an APNS VoIP sandbox channel
#'
#' @usage
#' pinpoint_delete_apns_voip_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_voip_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_voip_sandbox_channel
pinpoint_delete_apns_voip_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsVoipSandboxChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_voip_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_voip_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_voip_sandbox_channel <- pinpoint_delete_apns_voip_sandbox_channel

#' Deletes an app
#'
#' Deletes an app.
#'
#' @usage
#' pinpoint_delete_app(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_app(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_app
pinpoint_delete_app <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_app_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_app_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_app <- pinpoint_delete_app

#' Delete a BAIDU GCM channel
#'
#' Delete a BAIDU GCM channel
#'
#' @usage
#' pinpoint_delete_baidu_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_baidu_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_baidu_channel
pinpoint_delete_baidu_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteBaiduChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$delete_baidu_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_baidu_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_baidu_channel <- pinpoint_delete_baidu_channel

#' Deletes a campaign
#'
#' Deletes a campaign.
#'
#' @usage
#' pinpoint_delete_campaign(ApplicationId, CampaignId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param CampaignId &#91;required&#93; The unique ID of the campaign.
#'
#' @section Request syntax:
#' ```
#' svc$delete_campaign(
#'   ApplicationId = "string",
#'   CampaignId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_campaign
pinpoint_delete_campaign <- function(ApplicationId, CampaignId) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId)
  output <- .pinpoint$delete_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_campaign <- pinpoint_delete_campaign

#' Delete an email channel
#'
#' Delete an email channel.
#'
#' @usage
#' pinpoint_delete_email_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_email_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_email_channel
pinpoint_delete_email_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteEmailChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$delete_email_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_email_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_email_channel <- pinpoint_delete_email_channel

#' Deletes an endpoint
#'
#' Deletes an endpoint.
#'
#' @usage
#' pinpoint_delete_endpoint(ApplicationId, EndpointId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param EndpointId &#91;required&#93; The unique ID of the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint(
#'   ApplicationId = "string",
#'   EndpointId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_endpoint
pinpoint_delete_endpoint <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$delete_endpoint_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_endpoint <- pinpoint_delete_endpoint

#' Deletes the event stream for an app
#'
#' Deletes the event stream for an app.
#'
#' @usage
#' pinpoint_delete_event_stream(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_stream(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_event_stream
pinpoint_delete_event_stream <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteEventStream",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$delete_event_stream_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_event_stream_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_event_stream <- pinpoint_delete_event_stream

#' Deletes the GCM channel for an app
#'
#' Deletes the GCM channel for an app.
#'
#' @usage
#' pinpoint_delete_gcm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_gcm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_gcm_channel
pinpoint_delete_gcm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteGcmChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$delete_gcm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_gcm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_gcm_channel <- pinpoint_delete_gcm_channel

#' Deletes a segment
#'
#' Deletes a segment.
#'
#' @usage
#' pinpoint_delete_segment(ApplicationId, SegmentId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#'
#' @section Request syntax:
#' ```
#' svc$delete_segment(
#'   ApplicationId = "string",
#'   SegmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_segment
pinpoint_delete_segment <- function(ApplicationId, SegmentId) {
  op <- new_operation(
    name = "DeleteSegment",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId)
  output <- .pinpoint$delete_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_segment <- pinpoint_delete_segment

#' Delete an SMS channel
#'
#' Delete an SMS channel.
#'
#' @usage
#' pinpoint_delete_sms_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_sms_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_sms_channel
pinpoint_delete_sms_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteSmsChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$delete_sms_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_sms_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_sms_channel <- pinpoint_delete_sms_channel

#' Deletes endpoints that are associated with a User ID
#'
#' Deletes endpoints that are associated with a User ID.
#'
#' @usage
#' pinpoint_delete_user_endpoints(ApplicationId, UserId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param UserId &#91;required&#93; The unique ID of the user.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_endpoints(
#'   ApplicationId = "string",
#'   UserId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_user_endpoints
pinpoint_delete_user_endpoints <- function(ApplicationId, UserId) {
  op <- new_operation(
    name = "DeleteUserEndpoints",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/users/{user-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_user_endpoints_input(ApplicationId = ApplicationId, UserId = UserId)
  output <- .pinpoint$delete_user_endpoints_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_user_endpoints <- pinpoint_delete_user_endpoints

#' Delete an Voice channel
#'
#' Delete an Voice channel
#'
#' @usage
#' pinpoint_delete_voice_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_voice_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_voice_channel
pinpoint_delete_voice_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteVoiceChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$delete_voice_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_voice_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_voice_channel <- pinpoint_delete_voice_channel

#' Get an ADM channel
#'
#' Get an ADM channel.
#'
#' @usage
#' pinpoint_get_adm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_adm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_adm_channel
pinpoint_get_adm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetAdmChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$get_adm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_adm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_adm_channel <- pinpoint_get_adm_channel

#' Returns information about the APNs channel for an app
#'
#' Returns information about the APNs channel for an app.
#'
#' @usage
#' pinpoint_get_apns_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_channel
pinpoint_get_apns_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$get_apns_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_channel <- pinpoint_get_apns_channel

#' Get an APNS sandbox channel
#'
#' Get an APNS sandbox channel.
#'
#' @usage
#' pinpoint_get_apns_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_sandbox_channel
pinpoint_get_apns_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsSandboxChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$get_apns_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_sandbox_channel <- pinpoint_get_apns_sandbox_channel

#' Get an APNS VoIP channel
#'
#' Get an APNS VoIP channel
#'
#' @usage
#' pinpoint_get_apns_voip_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_voip_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_voip_channel
pinpoint_get_apns_voip_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsVoipChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$get_apns_voip_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_voip_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_voip_channel <- pinpoint_get_apns_voip_channel

#' Get an APNS VoIPSandbox channel
#'
#' Get an APNS VoIPSandbox channel
#'
#' @usage
#' pinpoint_get_apns_voip_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_voip_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_voip_sandbox_channel
pinpoint_get_apns_voip_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsVoipSandboxChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$get_apns_voip_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_voip_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_voip_sandbox_channel <- pinpoint_get_apns_voip_sandbox_channel

#' Returns information about an app
#'
#' Returns information about an app.
#'
#' @usage
#' pinpoint_get_app(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_app(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_app
pinpoint_get_app <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApp",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}",
    paginator = list()
  )
  input <- .pinpoint$get_app_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_app_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_app <- pinpoint_get_app

#' Used to request the settings for an app
#'
#' Used to request the settings for an app.
#'
#' @usage
#' pinpoint_get_application_settings(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_application_settings(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_application_settings
pinpoint_get_application_settings <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApplicationSettings",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/settings",
    paginator = list()
  )
  input <- .pinpoint$get_application_settings_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_application_settings_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_application_settings <- pinpoint_get_application_settings

#' Returns information about your apps
#'
#' Returns information about your apps.
#'
#' @usage
#' pinpoint_get_apps(PageSize, Token)
#'
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_apps(
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apps
pinpoint_get_apps <- function(PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetApps",
    http_method = "GET",
    http_path = "/v1/apps",
    paginator = list()
  )
  input <- .pinpoint$get_apps_input(PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_apps_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apps <- pinpoint_get_apps

#' Get a BAIDU GCM channel
#'
#' Get a BAIDU GCM channel
#'
#' @usage
#' pinpoint_get_baidu_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_baidu_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_baidu_channel
pinpoint_get_baidu_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetBaiduChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$get_baidu_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_baidu_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_baidu_channel <- pinpoint_get_baidu_channel

#' Returns information about a campaign
#'
#' Returns information about a campaign.
#'
#' @usage
#' pinpoint_get_campaign(ApplicationId, CampaignId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param CampaignId &#91;required&#93; The unique ID of the campaign.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign(
#'   ApplicationId = "string",
#'   CampaignId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign
pinpoint_get_campaign <- function(ApplicationId, CampaignId) {
  op <- new_operation(
    name = "GetCampaign",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId)
  output <- .pinpoint$get_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign <- pinpoint_get_campaign

#' Returns information about the activity performed by a campaign
#'
#' Returns information about the activity performed by a campaign.
#'
#' @usage
#' pinpoint_get_campaign_activities(ApplicationId, CampaignId, PageSize,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param CampaignId &#91;required&#93; The unique ID of the campaign.
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign_activities(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_activities
pinpoint_get_campaign_activities <- function(ApplicationId, CampaignId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaignActivities",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_activities_input(ApplicationId = ApplicationId, CampaignId = CampaignId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaign_activities_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_activities <- pinpoint_get_campaign_activities

#' Returns information about a specific version of a campaign
#'
#' Returns information about a specific version of a campaign.
#'
#' @usage
#' pinpoint_get_campaign_version(ApplicationId, CampaignId, Version)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param CampaignId &#91;required&#93; The unique ID of the campaign.
#' @param Version &#91;required&#93; The version of the campaign.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign_version(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   Version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_version
pinpoint_get_campaign_version <- function(ApplicationId, CampaignId, Version) {
  op <- new_operation(
    name = "GetCampaignVersion",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_version_input(ApplicationId = ApplicationId, CampaignId = CampaignId, Version = Version)
  output <- .pinpoint$get_campaign_version_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_version <- pinpoint_get_campaign_version

#' Returns information about your campaign versions
#'
#' Returns information about your campaign versions.
#'
#' @usage
#' pinpoint_get_campaign_versions(ApplicationId, CampaignId, PageSize,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param CampaignId &#91;required&#93; The unique ID of the campaign.
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign_versions(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_versions
pinpoint_get_campaign_versions <- function(ApplicationId, CampaignId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaignVersions",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_versions_input(ApplicationId = ApplicationId, CampaignId = CampaignId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaign_versions_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_versions <- pinpoint_get_campaign_versions

#' Returns information about your campaigns
#'
#' Returns information about your campaigns.
#'
#' @usage
#' pinpoint_get_campaigns(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaigns(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaigns
pinpoint_get_campaigns <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaigns",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns",
    paginator = list()
  )
  input <- .pinpoint$get_campaigns_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaigns_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaigns <- pinpoint_get_campaigns

#' Get all channels
#'
#' Get all channels.
#'
#' @usage
#' pinpoint_get_channels(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_channels(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_channels
pinpoint_get_channels <- function(ApplicationId) {
  op <- new_operation(
    name = "GetChannels",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels",
    paginator = list()
  )
  input <- .pinpoint$get_channels_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_channels_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_channels <- pinpoint_get_channels

#' Get an email channel
#'
#' Get an email channel.
#'
#' @usage
#' pinpoint_get_email_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_email_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_email_channel
pinpoint_get_email_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetEmailChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$get_email_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_email_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_email_channel <- pinpoint_get_email_channel

#' Returns information about an endpoint
#'
#' Returns information about an endpoint.
#'
#' @usage
#' pinpoint_get_endpoint(ApplicationId, EndpointId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param EndpointId &#91;required&#93; The unique ID of the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$get_endpoint(
#'   ApplicationId = "string",
#'   EndpointId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_endpoint
pinpoint_get_endpoint <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "GetEndpoint",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$get_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$get_endpoint_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_endpoint <- pinpoint_get_endpoint

#' Returns the event stream for an app
#'
#' Returns the event stream for an app.
#'
#' @usage
#' pinpoint_get_event_stream(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_event_stream(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_event_stream
pinpoint_get_event_stream <- function(ApplicationId) {
  op <- new_operation(
    name = "GetEventStream",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$get_event_stream_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_event_stream_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_event_stream <- pinpoint_get_event_stream

#' Returns information about an export job
#'
#' Returns information about an export job.
#'
#' @usage
#' pinpoint_get_export_job(ApplicationId, JobId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param JobId &#91;required&#93; The unique ID of the job.
#'
#' @section Request syntax:
#' ```
#' svc$get_export_job(
#'   ApplicationId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_export_job
pinpoint_get_export_job <- function(ApplicationId, JobId) {
  op <- new_operation(
    name = "GetExportJob",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/export/{job-id}",
    paginator = list()
  )
  input <- .pinpoint$get_export_job_input(ApplicationId = ApplicationId, JobId = JobId)
  output <- .pinpoint$get_export_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_export_job <- pinpoint_get_export_job

#' Returns information about your export jobs
#'
#' Returns information about your export jobs.
#'
#' @usage
#' pinpoint_get_export_jobs(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_export_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_export_jobs
pinpoint_get_export_jobs <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetExportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$get_export_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_export_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_export_jobs <- pinpoint_get_export_jobs

#' Returns information about the GCM channel for an app
#'
#' Returns information about the GCM channel for an app.
#'
#' @usage
#' pinpoint_get_gcm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_gcm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_gcm_channel
pinpoint_get_gcm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetGcmChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$get_gcm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_gcm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_gcm_channel <- pinpoint_get_gcm_channel

#' Returns information about an import job
#'
#' Returns information about an import job.
#'
#' @usage
#' pinpoint_get_import_job(ApplicationId, JobId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param JobId &#91;required&#93; The unique ID of the job.
#'
#' @section Request syntax:
#' ```
#' svc$get_import_job(
#'   ApplicationId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_import_job
pinpoint_get_import_job <- function(ApplicationId, JobId) {
  op <- new_operation(
    name = "GetImportJob",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/import/{job-id}",
    paginator = list()
  )
  input <- .pinpoint$get_import_job_input(ApplicationId = ApplicationId, JobId = JobId)
  output <- .pinpoint$get_import_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_import_job <- pinpoint_get_import_job

#' Returns information about your import jobs
#'
#' Returns information about your import jobs.
#'
#' @usage
#' pinpoint_get_import_jobs(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_import_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_import_jobs
pinpoint_get_import_jobs <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetImportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$get_import_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_import_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_import_jobs <- pinpoint_get_import_jobs

#' Returns information about a segment
#'
#' Returns information about a segment.
#'
#' @usage
#' pinpoint_get_segment(ApplicationId, SegmentId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment(
#'   ApplicationId = "string",
#'   SegmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment
pinpoint_get_segment <- function(ApplicationId, SegmentId) {
  op <- new_operation(
    name = "GetSegment",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$get_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId)
  output <- .pinpoint$get_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment <- pinpoint_get_segment

#' Returns a list of export jobs for a specific segment
#'
#' Returns a list of export jobs for a specific segment.
#'
#' @usage
#' pinpoint_get_segment_export_jobs(ApplicationId, PageSize, SegmentId,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_export_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   SegmentId = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_export_jobs
pinpoint_get_segment_export_jobs <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentExportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$get_segment_export_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_export_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_export_jobs <- pinpoint_get_segment_export_jobs

#' Returns a list of import jobs for a specific segment
#'
#' Returns a list of import jobs for a specific segment.
#'
#' @usage
#' pinpoint_get_segment_import_jobs(ApplicationId, PageSize, SegmentId,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_import_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   SegmentId = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_import_jobs
pinpoint_get_segment_import_jobs <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentImportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$get_segment_import_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_import_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_import_jobs <- pinpoint_get_segment_import_jobs

#' Returns information about a segment version
#'
#' Returns information about a segment version.
#'
#' @usage
#' pinpoint_get_segment_version(ApplicationId, SegmentId, Version)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#' @param Version &#91;required&#93; The segment version.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_version(
#'   ApplicationId = "string",
#'   SegmentId = "string",
#'   Version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_version
pinpoint_get_segment_version <- function(ApplicationId, SegmentId, Version) {
  op <- new_operation(
    name = "GetSegmentVersion",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
    paginator = list()
  )
  input <- .pinpoint$get_segment_version_input(ApplicationId = ApplicationId, SegmentId = SegmentId, Version = Version)
  output <- .pinpoint$get_segment_version_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_version <- pinpoint_get_segment_version

#' Returns information about your segment versions
#'
#' Returns information about your segment versions.
#'
#' @usage
#' pinpoint_get_segment_versions(ApplicationId, PageSize, SegmentId, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_versions(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   SegmentId = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_versions
pinpoint_get_segment_versions <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentVersions",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/versions",
    paginator = list()
  )
  input <- .pinpoint$get_segment_versions_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_versions_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_versions <- pinpoint_get_segment_versions

#' Used to get information about your segments
#'
#' Used to get information about your segments.
#'
#' @usage
#' pinpoint_get_segments(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param PageSize The number of entries you want on each page in the response.
#' @param Token The NextToken string returned on a previous page that you use to get the next page of results in a paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segments(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segments
pinpoint_get_segments <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetSegments",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments",
    paginator = list()
  )
  input <- .pinpoint$get_segments_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_segments_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segments <- pinpoint_get_segments

#' Get an SMS channel
#'
#' Get an SMS channel.
#'
#' @usage
#' pinpoint_get_sms_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_sms_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_sms_channel
pinpoint_get_sms_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetSmsChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$get_sms_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_sms_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_sms_channel <- pinpoint_get_sms_channel

#' Returns information about the endpoints that are associated with a User
#' ID
#'
#' Returns information about the endpoints that are associated with a User ID.
#'
#' @usage
#' pinpoint_get_user_endpoints(ApplicationId, UserId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param UserId &#91;required&#93; The unique ID of the user.
#'
#' @section Request syntax:
#' ```
#' svc$get_user_endpoints(
#'   ApplicationId = "string",
#'   UserId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_user_endpoints
pinpoint_get_user_endpoints <- function(ApplicationId, UserId) {
  op <- new_operation(
    name = "GetUserEndpoints",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/users/{user-id}",
    paginator = list()
  )
  input <- .pinpoint$get_user_endpoints_input(ApplicationId = ApplicationId, UserId = UserId)
  output <- .pinpoint$get_user_endpoints_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_user_endpoints <- pinpoint_get_user_endpoints

#' Get a Voice Channel
#'
#' Get a Voice Channel
#'
#' @usage
#' pinpoint_get_voice_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$get_voice_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_voice_channel
pinpoint_get_voice_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetVoiceChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$get_voice_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_voice_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_voice_channel <- pinpoint_get_voice_channel

#' List tags for resource
#'
#' 
#'
#' @usage
#' pinpoint_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_list_tags_for_resource
pinpoint_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpoint$list_tags_for_resource_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$list_tags_for_resource <- pinpoint_list_tags_for_resource

#' Returns information about the specified phone number
#'
#' Returns information about the specified phone number.
#'
#' @usage
#' pinpoint_phone_number_validate(NumberValidateRequest)
#'
#' @param NumberValidateRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$phone_number_validate(
#'   NumberValidateRequest = list(
#'     IsoCountryCode = "string",
#'     PhoneNumber = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_phone_number_validate
pinpoint_phone_number_validate <- function(NumberValidateRequest) {
  op <- new_operation(
    name = "PhoneNumberValidate",
    http_method = "POST",
    http_path = "/v1/phone/number/validate",
    paginator = list()
  )
  input <- .pinpoint$phone_number_validate_input(NumberValidateRequest = NumberValidateRequest)
  output <- .pinpoint$phone_number_validate_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$phone_number_validate <- pinpoint_phone_number_validate

#' Use to create or update the event stream for an app
#'
#' Use to create or update the event stream for an app.
#'
#' @usage
#' pinpoint_put_event_stream(ApplicationId, WriteEventStream)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param WriteEventStream &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_event_stream(
#'   ApplicationId = "string",
#'   WriteEventStream = list(
#'     DestinationStreamArn = "string",
#'     RoleArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_put_event_stream
pinpoint_put_event_stream <- function(ApplicationId, WriteEventStream) {
  op <- new_operation(
    name = "PutEventStream",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$put_event_stream_input(ApplicationId = ApplicationId, WriteEventStream = WriteEventStream)
  output <- .pinpoint$put_event_stream_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$put_event_stream <- pinpoint_put_event_stream

#' Use to record events for endpoints
#'
#' Use to record events for endpoints. This method creates events and creates or updates the endpoints that those events are associated with.
#'
#' @usage
#' pinpoint_put_events(ApplicationId, EventsRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param EventsRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_events(
#'   ApplicationId = "string",
#'   EventsRequest = list(
#'     BatchItem = list(
#'       list(
#'         Endpoint = list(
#'           Address = "string",
#'           Attributes = list(
#'             list(
#'               "string"
#'             )
#'           ),
#'           ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'           Demographic = list(
#'             AppVersion = "string",
#'             Locale = "string",
#'             Make = "string",
#'             Model = "string",
#'             ModelVersion = "string",
#'             Platform = "string",
#'             PlatformVersion = "string",
#'             Timezone = "string"
#'           ),
#'           EffectiveDate = "string",
#'           EndpointStatus = "string",
#'           Location = list(
#'             City = "string",
#'             Country = "string",
#'             Latitude = 123.0,
#'             Longitude = 123.0,
#'             PostalCode = "string",
#'             Region = "string"
#'           ),
#'           Metrics = list(
#'             123.0
#'           ),
#'           OptOut = "string",
#'           RequestId = "string",
#'           User = list(
#'             UserAttributes = list(
#'               list(
#'                 "string"
#'               )
#'             ),
#'             UserId = "string"
#'           )
#'         ),
#'         Events = list(
#'           list(
#'             AppPackageName = "string",
#'             AppTitle = "string",
#'             AppVersionCode = "string",
#'             Attributes = list(
#'               "string"
#'             ),
#'             ClientSdkVersion = "string",
#'             EventType = "string",
#'             Metrics = list(
#'               123.0
#'             ),
#'             SdkName = "string",
#'             Session = list(
#'               Duration = 123,
#'               Id = "string",
#'               StartTimestamp = "string",
#'               StopTimestamp = "string"
#'             ),
#'             Timestamp = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_put_events
pinpoint_put_events <- function(ApplicationId, EventsRequest) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/events",
    paginator = list()
  )
  input <- .pinpoint$put_events_input(ApplicationId = ApplicationId, EventsRequest = EventsRequest)
  output <- .pinpoint$put_events_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$put_events <- pinpoint_put_events

#' Used to remove the attributes for an app
#'
#' Used to remove the attributes for an app
#'
#' @usage
#' pinpoint_remove_attributes(ApplicationId, AttributeType,
#'   UpdateAttributesRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param AttributeType &#91;required&#93; Type of attribute. Can be endpoint-custom-attributes, endpoint-custom-metrics, endpoint-user-attributes.
#' @param UpdateAttributesRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$remove_attributes(
#'   ApplicationId = "string",
#'   AttributeType = "string",
#'   UpdateAttributesRequest = list(
#'     Blacklist = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_remove_attributes
pinpoint_remove_attributes <- function(ApplicationId, AttributeType, UpdateAttributesRequest) {
  op <- new_operation(
    name = "RemoveAttributes",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/attributes/{attribute-type}",
    paginator = list()
  )
  input <- .pinpoint$remove_attributes_input(ApplicationId = ApplicationId, AttributeType = AttributeType, UpdateAttributesRequest = UpdateAttributesRequest)
  output <- .pinpoint$remove_attributes_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$remove_attributes <- pinpoint_remove_attributes

#' Used to send a direct message
#'
#' Used to send a direct message.
#'
#' @usage
#' pinpoint_send_messages(ApplicationId, MessageRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param MessageRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$send_messages(
#'   ApplicationId = "string",
#'   MessageRequest = list(
#'     Addresses = list(
#'       list(
#'         BodyOverride = "string",
#'         ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'         Context = list(
#'           "string"
#'         ),
#'         RawContent = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TitleOverride = "string"
#'       )
#'     ),
#'     Context = list(
#'       "string"
#'     ),
#'     Endpoints = list(
#'       list(
#'         BodyOverride = "string",
#'         Context = list(
#'           "string"
#'         ),
#'         RawContent = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TitleOverride = "string"
#'       )
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ConsolidationKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         ExpiresAfter = "string",
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         MD5 = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Badge = 123,
#'         Body = "string",
#'         Category = "string",
#'         CollapseId = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         MediaUrl = "string",
#'         PreferredAuthenticationMethod = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         ThreadId = "string",
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Body = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       DefaultPushNotificationMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         SilentPush = TRUE|FALSE,
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FeedbackForwardingAddress = "string",
#'         FromAddress = "string",
#'         RawEmail = list(
#'           Data = raw
#'         ),
#'         ReplyToAddresses = list(
#'           "string"
#'         ),
#'         SimpleEmail = list(
#'           HtmlPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           Subject = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           TextPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           )
#'         ),
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         CollapseKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         RestrictedPackageName = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         Keyword = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         OriginationNumber = "string",
#'         SenderId = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       VoiceMessage = list(
#'         Body = "string",
#'         LanguageCode = "string",
#'         OriginationNumber = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         VoiceId = "string"
#'       )
#'     ),
#'     TraceId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_messages
pinpoint_send_messages <- function(ApplicationId, MessageRequest) {
  op <- new_operation(
    name = "SendMessages",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/messages",
    paginator = list()
  )
  input <- .pinpoint$send_messages_input(ApplicationId = ApplicationId, MessageRequest = MessageRequest)
  output <- .pinpoint$send_messages_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_messages <- pinpoint_send_messages

#' Used to send a message to a list of users
#'
#' Used to send a message to a list of users.
#'
#' @usage
#' pinpoint_send_users_messages(ApplicationId, SendUsersMessageRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SendUsersMessageRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$send_users_messages(
#'   ApplicationId = "string",
#'   SendUsersMessageRequest = list(
#'     Context = list(
#'       "string"
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ConsolidationKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         ExpiresAfter = "string",
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         MD5 = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Badge = 123,
#'         Body = "string",
#'         Category = "string",
#'         CollapseId = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         MediaUrl = "string",
#'         PreferredAuthenticationMethod = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         ThreadId = "string",
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Body = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       DefaultPushNotificationMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         SilentPush = TRUE|FALSE,
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FeedbackForwardingAddress = "string",
#'         FromAddress = "string",
#'         RawEmail = list(
#'           Data = raw
#'         ),
#'         ReplyToAddresses = list(
#'           "string"
#'         ),
#'         SimpleEmail = list(
#'           HtmlPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           Subject = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           TextPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           )
#'         ),
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         CollapseKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         RestrictedPackageName = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         Keyword = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         OriginationNumber = "string",
#'         SenderId = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       VoiceMessage = list(
#'         Body = "string",
#'         LanguageCode = "string",
#'         OriginationNumber = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         VoiceId = "string"
#'       )
#'     ),
#'     TraceId = "string",
#'     Users = list(
#'       list(
#'         BodyOverride = "string",
#'         Context = list(
#'           "string"
#'         ),
#'         RawContent = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TitleOverride = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_users_messages
pinpoint_send_users_messages <- function(ApplicationId, SendUsersMessageRequest) {
  op <- new_operation(
    name = "SendUsersMessages",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/users-messages",
    paginator = list()
  )
  input <- .pinpoint$send_users_messages_input(ApplicationId = ApplicationId, SendUsersMessageRequest = SendUsersMessageRequest)
  output <- .pinpoint$send_users_messages_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_users_messages <- pinpoint_send_users_messages

#' Tag resource
#'
#' 
#'
#' @usage
#' pinpoint_tag_resource(ResourceArn, TagsModel)
#'
#' @param ResourceArn &#91;required&#93; 
#' @param TagsModel &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   TagsModel = list(
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_tag_resource
pinpoint_tag_resource <- function(ResourceArn, TagsModel) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$tag_resource_input(ResourceArn = ResourceArn, TagsModel = TagsModel)
  output <- .pinpoint$tag_resource_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$tag_resource <- pinpoint_tag_resource

#' Untag resource
#'
#' 
#'
#' @usage
#' pinpoint_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; 
#' @param TagKeys &#91;required&#93; The key(s) of tag to be deleted
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_untag_resource
pinpoint_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpoint$untag_resource_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$untag_resource <- pinpoint_untag_resource

#' Update an ADM channel
#'
#' Update an ADM channel.
#'
#' @usage
#' pinpoint_update_adm_channel(ADMChannelRequest, ApplicationId)
#'
#' @param ADMChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$update_adm_channel(
#'   ADMChannelRequest = list(
#'     ClientId = "string",
#'     ClientSecret = "string",
#'     Enabled = TRUE|FALSE
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_adm_channel
pinpoint_update_adm_channel <- function(ADMChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateAdmChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$update_adm_channel_input(ADMChannelRequest = ADMChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_adm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_adm_channel <- pinpoint_update_adm_channel

#' Use to update the APNs channel for an app
#'
#' Use to update the APNs channel for an app.
#'
#' @usage
#' pinpoint_update_apns_channel(APNSChannelRequest, ApplicationId)
#'
#' @param APNSChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_channel(
#'   APNSChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_channel
pinpoint_update_apns_channel <- function(APNSChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$update_apns_channel_input(APNSChannelRequest = APNSChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_channel <- pinpoint_update_apns_channel

#' Update an APNS sandbox channel
#'
#' Update an APNS sandbox channel.
#'
#' @usage
#' pinpoint_update_apns_sandbox_channel(APNSSandboxChannelRequest,
#'   ApplicationId)
#'
#' @param APNSSandboxChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_sandbox_channel(
#'   APNSSandboxChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_sandbox_channel
pinpoint_update_apns_sandbox_channel <- function(APNSSandboxChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsSandboxChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$update_apns_sandbox_channel_input(APNSSandboxChannelRequest = APNSSandboxChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_sandbox_channel <- pinpoint_update_apns_sandbox_channel

#' Update an APNS VoIP channel
#'
#' Update an APNS VoIP channel
#'
#' @usage
#' pinpoint_update_apns_voip_channel(APNSVoipChannelRequest, ApplicationId)
#'
#' @param APNSVoipChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_voip_channel(
#'   APNSVoipChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_voip_channel
pinpoint_update_apns_voip_channel <- function(APNSVoipChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsVoipChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$update_apns_voip_channel_input(APNSVoipChannelRequest = APNSVoipChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_voip_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_voip_channel <- pinpoint_update_apns_voip_channel

#' Update an APNS VoIP sandbox channel
#'
#' Update an APNS VoIP sandbox channel
#'
#' @usage
#' pinpoint_update_apns_voip_sandbox_channel(APNSVoipSandboxChannelRequest,
#'   ApplicationId)
#'
#' @param APNSVoipSandboxChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_voip_sandbox_channel(
#'   APNSVoipSandboxChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_voip_sandbox_channel
pinpoint_update_apns_voip_sandbox_channel <- function(APNSVoipSandboxChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsVoipSandboxChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$update_apns_voip_sandbox_channel_input(APNSVoipSandboxChannelRequest = APNSVoipSandboxChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_voip_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_voip_sandbox_channel <- pinpoint_update_apns_voip_sandbox_channel

#' Used to update the settings for an app
#'
#' Used to update the settings for an app.
#'
#' @usage
#' pinpoint_update_application_settings(ApplicationId,
#'   WriteApplicationSettingsRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param WriteApplicationSettingsRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_application_settings(
#'   ApplicationId = "string",
#'   WriteApplicationSettingsRequest = list(
#'     CampaignHook = list(
#'       LambdaFunctionName = "string",
#'       Mode = "DELIVERY"|"FILTER",
#'       WebUrl = "string"
#'     ),
#'     CloudWatchMetricsEnabled = TRUE|FALSE,
#'     Limits = list(
#'       Daily = 123,
#'       MaximumDuration = 123,
#'       MessagesPerSecond = 123,
#'       Total = 123
#'     ),
#'     QuietTime = list(
#'       End = "string",
#'       Start = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_application_settings
pinpoint_update_application_settings <- function(ApplicationId, WriteApplicationSettingsRequest) {
  op <- new_operation(
    name = "UpdateApplicationSettings",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/settings",
    paginator = list()
  )
  input <- .pinpoint$update_application_settings_input(ApplicationId = ApplicationId, WriteApplicationSettingsRequest = WriteApplicationSettingsRequest)
  output <- .pinpoint$update_application_settings_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_application_settings <- pinpoint_update_application_settings

#' Update a BAIDU GCM channel
#'
#' Update a BAIDU GCM channel
#'
#' @usage
#' pinpoint_update_baidu_channel(ApplicationId, BaiduChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param BaiduChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_baidu_channel(
#'   ApplicationId = "string",
#'   BaiduChannelRequest = list(
#'     ApiKey = "string",
#'     Enabled = TRUE|FALSE,
#'     SecretKey = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_baidu_channel
pinpoint_update_baidu_channel <- function(ApplicationId, BaiduChannelRequest) {
  op <- new_operation(
    name = "UpdateBaiduChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$update_baidu_channel_input(ApplicationId = ApplicationId, BaiduChannelRequest = BaiduChannelRequest)
  output <- .pinpoint$update_baidu_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_baidu_channel <- pinpoint_update_baidu_channel

#' Use to update a campaign
#'
#' Use to update a campaign.
#'
#' @usage
#' pinpoint_update_campaign(ApplicationId, CampaignId,
#'   WriteCampaignRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param CampaignId &#91;required&#93; The unique ID of the campaign.
#' @param WriteCampaignRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_campaign(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   WriteCampaignRequest = list(
#'     AdditionalTreatments = list(
#'       list(
#'         MessageConfiguration = list(
#'           ADMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           APNSMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           BaiduMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           DefaultMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           EmailMessage = list(
#'             Body = "string",
#'             FromAddress = "string",
#'             HtmlBody = "string",
#'             Title = "string"
#'           ),
#'           GCMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           SMSMessage = list(
#'             Body = "string",
#'             MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'             SenderId = "string"
#'           )
#'         ),
#'         Schedule = list(
#'           EndTime = "string",
#'           EventFilter = list(
#'             Dimensions = list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               EventType = list(
#'                 DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                 Values = list(
#'                   "string"
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               )
#'             ),
#'             FilterType = "SYSTEM"|"ENDPOINT"
#'           ),
#'           Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'           IsLocalTime = TRUE|FALSE,
#'           QuietTime = list(
#'             End = "string",
#'             Start = "string"
#'           ),
#'           StartTime = "string",
#'           Timezone = "string"
#'         ),
#'         SizePercent = 123,
#'         TreatmentDescription = "string",
#'         TreatmentName = "string"
#'       )
#'     ),
#'     Description = "string",
#'     HoldoutPercent = 123,
#'     Hook = list(
#'       LambdaFunctionName = "string",
#'       Mode = "DELIVERY"|"FILTER",
#'       WebUrl = "string"
#'     ),
#'     IsPaused = TRUE|FALSE,
#'     Limits = list(
#'       Daily = 123,
#'       MaximumDuration = 123,
#'       MessagesPerSecond = 123,
#'       Total = 123
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FromAddress = "string",
#'         HtmlBody = "string",
#'         Title = "string"
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         SenderId = "string"
#'       )
#'     ),
#'     Name = "string",
#'     Schedule = list(
#'       EndTime = "string",
#'       EventFilter = list(
#'         Dimensions = list(
#'           Attributes = list(
#'             list(
#'               AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           EventType = list(
#'             DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'             Values = list(
#'               "string"
#'             )
#'           ),
#'           Metrics = list(
#'             list(
#'               ComparisonOperator = "string",
#'               Value = 123.0
#'             )
#'           )
#'         ),
#'         FilterType = "SYSTEM"|"ENDPOINT"
#'       ),
#'       Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'       IsLocalTime = TRUE|FALSE,
#'       QuietTime = list(
#'         End = "string",
#'         Start = "string"
#'       ),
#'       StartTime = "string",
#'       Timezone = "string"
#'     ),
#'     SegmentId = "string",
#'     SegmentVersion = 123,
#'     tags = list(
#'       "string"
#'     ),
#'     TreatmentDescription = "string",
#'     TreatmentName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_campaign
pinpoint_update_campaign <- function(ApplicationId, CampaignId, WriteCampaignRequest) {
  op <- new_operation(
    name = "UpdateCampaign",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$update_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId, WriteCampaignRequest = WriteCampaignRequest)
  output <- .pinpoint$update_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_campaign <- pinpoint_update_campaign

#' Update an email channel
#'
#' Update an email channel.
#'
#' @usage
#' pinpoint_update_email_channel(ApplicationId, EmailChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param EmailChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_email_channel(
#'   ApplicationId = "string",
#'   EmailChannelRequest = list(
#'     ConfigurationSet = "string",
#'     Enabled = TRUE|FALSE,
#'     FromAddress = "string",
#'     Identity = "string",
#'     RoleArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_email_channel
pinpoint_update_email_channel <- function(ApplicationId, EmailChannelRequest) {
  op <- new_operation(
    name = "UpdateEmailChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$update_email_channel_input(ApplicationId = ApplicationId, EmailChannelRequest = EmailChannelRequest)
  output <- .pinpoint$update_email_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_email_channel <- pinpoint_update_email_channel

#' Creates or updates an endpoint
#'
#' Creates or updates an endpoint.
#'
#' @usage
#' pinpoint_update_endpoint(ApplicationId, EndpointId, EndpointRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param EndpointId &#91;required&#93; The unique ID of the endpoint.
#' @param EndpointRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint(
#'   ApplicationId = "string",
#'   EndpointId = "string",
#'   EndpointRequest = list(
#'     Address = "string",
#'     Attributes = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'     Demographic = list(
#'       AppVersion = "string",
#'       Locale = "string",
#'       Make = "string",
#'       Model = "string",
#'       ModelVersion = "string",
#'       Platform = "string",
#'       PlatformVersion = "string",
#'       Timezone = "string"
#'     ),
#'     EffectiveDate = "string",
#'     EndpointStatus = "string",
#'     Location = list(
#'       City = "string",
#'       Country = "string",
#'       Latitude = 123.0,
#'       Longitude = 123.0,
#'       PostalCode = "string",
#'       Region = "string"
#'     ),
#'     Metrics = list(
#'       123.0
#'     ),
#'     OptOut = "string",
#'     RequestId = "string",
#'     User = list(
#'       UserAttributes = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       UserId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_endpoint
pinpoint_update_endpoint <- function(ApplicationId, EndpointId, EndpointRequest) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$update_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId, EndpointRequest = EndpointRequest)
  output <- .pinpoint$update_endpoint_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_endpoint <- pinpoint_update_endpoint

#' Use to update a batch of endpoints
#'
#' Use to update a batch of endpoints.
#'
#' @usage
#' pinpoint_update_endpoints_batch(ApplicationId, EndpointBatchRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param EndpointBatchRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoints_batch(
#'   ApplicationId = "string",
#'   EndpointBatchRequest = list(
#'     Item = list(
#'       list(
#'         Address = "string",
#'         Attributes = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'         Demographic = list(
#'           AppVersion = "string",
#'           Locale = "string",
#'           Make = "string",
#'           Model = "string",
#'           ModelVersion = "string",
#'           Platform = "string",
#'           PlatformVersion = "string",
#'           Timezone = "string"
#'         ),
#'         EffectiveDate = "string",
#'         EndpointStatus = "string",
#'         Id = "string",
#'         Location = list(
#'           City = "string",
#'           Country = "string",
#'           Latitude = 123.0,
#'           Longitude = 123.0,
#'           PostalCode = "string",
#'           Region = "string"
#'         ),
#'         Metrics = list(
#'           123.0
#'         ),
#'         OptOut = "string",
#'         RequestId = "string",
#'         User = list(
#'           UserAttributes = list(
#'             list(
#'               "string"
#'             )
#'           ),
#'           UserId = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_endpoints_batch
pinpoint_update_endpoints_batch <- function(ApplicationId, EndpointBatchRequest) {
  op <- new_operation(
    name = "UpdateEndpointsBatch",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/endpoints",
    paginator = list()
  )
  input <- .pinpoint$update_endpoints_batch_input(ApplicationId = ApplicationId, EndpointBatchRequest = EndpointBatchRequest)
  output <- .pinpoint$update_endpoints_batch_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_endpoints_batch <- pinpoint_update_endpoints_batch

#' Use to update the GCM channel for an app
#'
#' Use to update the GCM channel for an app.
#'
#' @usage
#' pinpoint_update_gcm_channel(ApplicationId, GCMChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param GCMChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_gcm_channel(
#'   ApplicationId = "string",
#'   GCMChannelRequest = list(
#'     ApiKey = "string",
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_gcm_channel
pinpoint_update_gcm_channel <- function(ApplicationId, GCMChannelRequest) {
  op <- new_operation(
    name = "UpdateGcmChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$update_gcm_channel_input(ApplicationId = ApplicationId, GCMChannelRequest = GCMChannelRequest)
  output <- .pinpoint$update_gcm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_gcm_channel <- pinpoint_update_gcm_channel

#' Used to update a segment
#'
#' Used to update a segment.
#'
#' @usage
#' pinpoint_update_segment(ApplicationId, SegmentId, WriteSegmentRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SegmentId &#91;required&#93; The unique ID of the segment.
#' @param WriteSegmentRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_segment(
#'   ApplicationId = "string",
#'   SegmentId = "string",
#'   WriteSegmentRequest = list(
#'     Dimensions = list(
#'       Attributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Behavior = list(
#'         Recency = list(
#'           Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'           RecencyType = "ACTIVE"|"INACTIVE"
#'         )
#'       ),
#'       Demographic = list(
#'         AppVersion = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Channel = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         DeviceType = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Make = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Model = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Platform = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = list(
#'         Country = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         GPSPoint = list(
#'           Coordinates = list(
#'             Latitude = 123.0,
#'             Longitude = 123.0
#'           ),
#'           RangeInKilometers = 123.0
#'         )
#'       ),
#'       Metrics = list(
#'         list(
#'           ComparisonOperator = "string",
#'           Value = 123.0
#'         )
#'       ),
#'       UserAttributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     Name = "string",
#'     SegmentGroups = list(
#'       Groups = list(
#'         list(
#'           Dimensions = list(
#'             list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Behavior = list(
#'                 Recency = list(
#'                   Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'                   RecencyType = "ACTIVE"|"INACTIVE"
#'                 )
#'               ),
#'               Demographic = list(
#'                 AppVersion = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Channel = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 DeviceType = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Make = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Model = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Platform = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Location = list(
#'                 Country = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 GPSPoint = list(
#'                   Coordinates = list(
#'                     Latitude = 123.0,
#'                     Longitude = 123.0
#'                   ),
#'                   RangeInKilometers = 123.0
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               ),
#'               UserAttributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           SourceSegments = list(
#'             list(
#'               Id = "string",
#'               Version = 123
#'             )
#'           ),
#'           SourceType = "ALL"|"ANY"|"NONE",
#'           Type = "ALL"|"ANY"|"NONE"
#'         )
#'       ),
#'       Include = "ALL"|"ANY"|"NONE"
#'     ),
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_segment
pinpoint_update_segment <- function(ApplicationId, SegmentId, WriteSegmentRequest) {
  op <- new_operation(
    name = "UpdateSegment",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$update_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId, WriteSegmentRequest = WriteSegmentRequest)
  output <- .pinpoint$update_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_segment <- pinpoint_update_segment

#' Update an SMS channel
#'
#' Update an SMS channel.
#'
#' @usage
#' pinpoint_update_sms_channel(ApplicationId, SMSChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param SMSChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_sms_channel(
#'   ApplicationId = "string",
#'   SMSChannelRequest = list(
#'     Enabled = TRUE|FALSE,
#'     SenderId = "string",
#'     ShortCode = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_sms_channel
pinpoint_update_sms_channel <- function(ApplicationId, SMSChannelRequest) {
  op <- new_operation(
    name = "UpdateSmsChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$update_sms_channel_input(ApplicationId = ApplicationId, SMSChannelRequest = SMSChannelRequest)
  output <- .pinpoint$update_sms_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_sms_channel <- pinpoint_update_sms_channel

#' Update an Voice channel
#'
#' Update an Voice channel
#'
#' @usage
#' pinpoint_update_voice_channel(ApplicationId, VoiceChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique ID of your Amazon Pinpoint application.
#' @param VoiceChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_voice_channel(
#'   ApplicationId = "string",
#'   VoiceChannelRequest = list(
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_voice_channel
pinpoint_update_voice_channel <- function(ApplicationId, VoiceChannelRequest) {
  op <- new_operation(
    name = "UpdateVoiceChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$update_voice_channel_input(ApplicationId = ApplicationId, VoiceChannelRequest = VoiceChannelRequest)
  output <- .pinpoint$update_voice_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_voice_channel <- pinpoint_update_voice_channel
