# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include pinpointsmsvoice_service.R
NULL

#' Create a new configuration set
#'
#' Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.
#'
#' @usage
#' pinpointsmsvoice_create_configuration_set(ConfigurationSetName)
#'
#' @param ConfigurationSetName The name that you want to give the configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_create_configuration_set
pinpointsmsvoice_create_configuration_set <- function(ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/v1/sms-voice/configuration-sets",
    paginator = list()
  )
  input <- .pinpointsmsvoice$create_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoice$create_configuration_set_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$create_configuration_set <- pinpointsmsvoice_create_configuration_set

#' Create a new event destination in a configuration set
#'
#' Create a new event destination in a configuration set.
#'
#' @usage
#' pinpointsmsvoice_create_configuration_set_event_destination(
#'   ConfigurationSetName, EventDestination, EventDestinationName)
#'
#' @param ConfigurationSetName &#91;required&#93; ConfigurationSetName
#' @param EventDestination 
#' @param EventDestinationName A name that identifies the event destination.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestination = list(
#'     CloudWatchLogsDestination = list(
#'       IamRoleArn = "string",
#'       LogGroupArn = "string"
#'     ),
#'     Enabled = TRUE|FALSE,
#'     KinesisFirehoseDestination = list(
#'       DeliveryStreamArn = "string",
#'       IamRoleArn = "string"
#'     ),
#'     MatchingEventTypes = list(
#'       "INITIATED_CALL"|"RINGING"|"ANSWERED"|"COMPLETED_CALL"|"BUSY"|"FAILED"|"NO_ANSWER"
#'     ),
#'     SnsDestination = list(
#'       TopicArn = "string"
#'     )
#'   ),
#'   EventDestinationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_create_configuration_set_event_destination
pinpointsmsvoice_create_configuration_set_event_destination <- function(ConfigurationSetName, EventDestination = NULL, EventDestinationName = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations",
    paginator = list()
  )
  input <- .pinpointsmsvoice$create_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestination = EventDestination, EventDestinationName = EventDestinationName)
  output <- .pinpointsmsvoice$create_configuration_set_event_destination_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$create_configuration_set_event_destination <- pinpointsmsvoice_create_configuration_set_event_destination

#' Deletes an existing configuration set
#'
#' Deletes an existing configuration set.
#'
#' @usage
#' pinpointsmsvoice_delete_configuration_set(ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; ConfigurationSetName
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_delete_configuration_set
pinpointsmsvoice_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "DELETE",
    http_path = "/v1/sms-voice/configuration-sets/{ConfigurationSetName}",
    paginator = list()
  )
  input <- .pinpointsmsvoice$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoice$delete_configuration_set_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$delete_configuration_set <- pinpointsmsvoice_delete_configuration_set

#' Deletes an event destination in a configuration set
#'
#' Deletes an event destination in a configuration set.
#'
#' @usage
#' pinpointsmsvoice_delete_configuration_set_event_destination(
#'   ConfigurationSetName, EventDestinationName)
#'
#' @param ConfigurationSetName &#91;required&#93; ConfigurationSetName
#' @param EventDestinationName &#91;required&#93; EventDestinationName
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestinationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_delete_configuration_set_event_destination
pinpointsmsvoice_delete_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteConfigurationSetEventDestination",
    http_method = "DELETE",
    http_path = "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    paginator = list()
  )
  input <- .pinpointsmsvoice$delete_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .pinpointsmsvoice$delete_configuration_set_event_destination_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$delete_configuration_set_event_destination <- pinpointsmsvoice_delete_configuration_set_event_destination

#' Obtain information about an event destination, including the types of
#' events it reports, the Amazon Resource Name (ARN) of the destination,
#' and the name of the event destination
#'
#' Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name (ARN) of the destination, and the name of the event destination.
#'
#' @usage
#' pinpointsmsvoice_get_configuration_set_event_destinations(
#'   ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; ConfigurationSetName
#'
#' @section Request syntax:
#' ```
#' svc$get_configuration_set_event_destinations(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_get_configuration_set_event_destinations
pinpointsmsvoice_get_configuration_set_event_destinations <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSetEventDestinations",
    http_method = "GET",
    http_path = "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations",
    paginator = list()
  )
  input <- .pinpointsmsvoice$get_configuration_set_event_destinations_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointsmsvoice$get_configuration_set_event_destinations_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$get_configuration_set_event_destinations <- pinpointsmsvoice_get_configuration_set_event_destinations

#' List all of the configuration sets associated with your Amazon Pinpoint
#' account in the current region
#'
#' List all of the configuration sets associated with your Amazon Pinpoint account in the current region.
#'
#' @usage
#' pinpointsmsvoice_list_configuration_sets(NextToken, PageSize)
#'
#' @param NextToken A token returned from a previous call to the API that indicates the position in the list of results.
#' @param PageSize Used to specify the number of items that should be returned in the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_configuration_sets(
#'   NextToken = "string",
#'   PageSize = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_list_configuration_sets
pinpointsmsvoice_list_configuration_sets <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListConfigurationSets",
    http_method = "GET",
    http_path = "/v1/sms-voice/configuration-sets",
    paginator = list()
  )
  input <- .pinpointsmsvoice$list_configuration_sets_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointsmsvoice$list_configuration_sets_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$list_configuration_sets <- pinpointsmsvoice_list_configuration_sets

#' Create a new voice message and send it to a recipient's phone number
#'
#' Create a new voice message and send it to a recipient's phone number.
#'
#' @usage
#' pinpointsmsvoice_send_voice_message(CallerId, ConfigurationSetName,
#'   Content, DestinationPhoneNumber, OriginationPhoneNumber)
#'
#' @param CallerId The phone number that appears on recipients' devices when they receive the message.
#' @param ConfigurationSetName The name of the configuration set that you want to use to send the message.
#' @param Content 
#' @param DestinationPhoneNumber The phone number that you want to send the voice message to.
#' @param OriginationPhoneNumber The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone number that appears on recipients' devices when they receive the message, because you can specify a CallerId parameter in the request.
#'
#' @section Request syntax:
#' ```
#' svc$send_voice_message(
#'   CallerId = "string",
#'   ConfigurationSetName = "string",
#'   Content = list(
#'     CallInstructionsMessage = list(
#'       Text = "string"
#'     ),
#'     PlainTextMessage = list(
#'       LanguageCode = "string",
#'       Text = "string",
#'       VoiceId = "string"
#'     ),
#'     SSMLMessage = list(
#'       LanguageCode = "string",
#'       Text = "string",
#'       VoiceId = "string"
#'     )
#'   ),
#'   DestinationPhoneNumber = "string",
#'   OriginationPhoneNumber = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_send_voice_message
pinpointsmsvoice_send_voice_message <- function(CallerId = NULL, ConfigurationSetName = NULL, Content = NULL, DestinationPhoneNumber = NULL, OriginationPhoneNumber = NULL) {
  op <- new_operation(
    name = "SendVoiceMessage",
    http_method = "POST",
    http_path = "/v1/sms-voice/voice/message",
    paginator = list()
  )
  input <- .pinpointsmsvoice$send_voice_message_input(CallerId = CallerId, ConfigurationSetName = ConfigurationSetName, Content = Content, DestinationPhoneNumber = DestinationPhoneNumber, OriginationPhoneNumber = OriginationPhoneNumber)
  output <- .pinpointsmsvoice$send_voice_message_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$send_voice_message <- pinpointsmsvoice_send_voice_message

#' Update an event destination in a configuration set
#'
#' Update an event destination in a configuration set. An event destination is a location that you publish information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when a call fails.
#'
#' @usage
#' pinpointsmsvoice_update_configuration_set_event_destination(
#'   ConfigurationSetName, EventDestination, EventDestinationName)
#'
#' @param ConfigurationSetName &#91;required&#93; ConfigurationSetName
#' @param EventDestination 
#' @param EventDestinationName &#91;required&#93; EventDestinationName
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestination = list(
#'     CloudWatchLogsDestination = list(
#'       IamRoleArn = "string",
#'       LogGroupArn = "string"
#'     ),
#'     Enabled = TRUE|FALSE,
#'     KinesisFirehoseDestination = list(
#'       DeliveryStreamArn = "string",
#'       IamRoleArn = "string"
#'     ),
#'     MatchingEventTypes = list(
#'       "INITIATED_CALL"|"RINGING"|"ANSWERED"|"COMPLETED_CALL"|"BUSY"|"FAILED"|"NO_ANSWER"
#'     ),
#'     SnsDestination = list(
#'       TopicArn = "string"
#'     )
#'   ),
#'   EventDestinationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointsmsvoice_update_configuration_set_event_destination
pinpointsmsvoice_update_configuration_set_event_destination <- function(ConfigurationSetName, EventDestination = NULL, EventDestinationName) {
  op <- new_operation(
    name = "UpdateConfigurationSetEventDestination",
    http_method = "PUT",
    http_path = "/v1/sms-voice/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    paginator = list()
  )
  input <- .pinpointsmsvoice$update_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestination = EventDestination, EventDestinationName = EventDestinationName)
  output <- .pinpointsmsvoice$update_configuration_set_event_destination_output()
  svc <- .pinpointsmsvoice$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointsmsvoice$operations$update_configuration_set_event_destination <- pinpointsmsvoice_update_configuration_set_event_destination
