% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_service.R
\name{pinpoint}
\alias{pinpoint}
\title{Amazon Pinpoint}
\usage{
pinpoint()
}
\description{
Amazon Pinpoint
}
\section{Operations}{

\tabular{ll}{
\link[=pinpoint_create_app]{create_app} \tab Creates or updates an app \cr
\link[=pinpoint_create_campaign]{create_campaign} \tab Creates or updates a campaign \cr
\link[=pinpoint_create_export_job]{create_export_job} \tab Creates an export job \cr
\link[=pinpoint_create_import_job]{create_import_job} \tab Creates or updates an import job \cr
\link[=pinpoint_create_segment]{create_segment} \tab Used to create or update a segment \cr
\link[=pinpoint_delete_adm_channel]{delete_adm_channel} \tab Delete an ADM channel \cr
\link[=pinpoint_delete_apns_channel]{delete_apns_channel} \tab Deletes the APNs channel for an app \cr
\link[=pinpoint_delete_apns_sandbox_channel]{delete_apns_sandbox_channel} \tab Delete an APNS sandbox channel \cr
\link[=pinpoint_delete_apns_voip_channel]{delete_apns_voip_channel} \tab Delete an APNS VoIP channel \cr
\link[=pinpoint_delete_apns_voip_sandbox_channel]{delete_apns_voip_sandbox_channel} \tab Delete an APNS VoIP sandbox channel \cr
\link[=pinpoint_delete_app]{delete_app} \tab Deletes an app \cr
\link[=pinpoint_delete_baidu_channel]{delete_baidu_channel} \tab Delete a BAIDU GCM channel \cr
\link[=pinpoint_delete_campaign]{delete_campaign} \tab Deletes a campaign \cr
\link[=pinpoint_delete_email_channel]{delete_email_channel} \tab Delete an email channel \cr
\link[=pinpoint_delete_endpoint]{delete_endpoint} \tab Deletes an endpoint \cr
\link[=pinpoint_delete_event_stream]{delete_event_stream} \tab Deletes the event stream for an app \cr
\link[=pinpoint_delete_gcm_channel]{delete_gcm_channel} \tab Deletes the GCM channel for an app \cr
\link[=pinpoint_delete_segment]{delete_segment} \tab Deletes a segment \cr
\link[=pinpoint_delete_sms_channel]{delete_sms_channel} \tab Delete an SMS channel \cr
\link[=pinpoint_delete_user_endpoints]{delete_user_endpoints} \tab Deletes endpoints that are associated with a User ID \cr
\link[=pinpoint_delete_voice_channel]{delete_voice_channel} \tab Delete an Voice channel \cr
\link[=pinpoint_get_adm_channel]{get_adm_channel} \tab Get an ADM channel \cr
\link[=pinpoint_get_apns_channel]{get_apns_channel} \tab Returns information about the APNs channel for an app \cr
\link[=pinpoint_get_apns_sandbox_channel]{get_apns_sandbox_channel} \tab Get an APNS sandbox channel \cr
\link[=pinpoint_get_apns_voip_channel]{get_apns_voip_channel} \tab Get an APNS VoIP channel \cr
\link[=pinpoint_get_apns_voip_sandbox_channel]{get_apns_voip_sandbox_channel} \tab Get an APNS VoIPSandbox channel \cr
\link[=pinpoint_get_app]{get_app} \tab Returns information about an app \cr
\link[=pinpoint_get_application_settings]{get_application_settings} \tab Used to request the settings for an app \cr
\link[=pinpoint_get_apps]{get_apps} \tab Returns information about your apps \cr
\link[=pinpoint_get_baidu_channel]{get_baidu_channel} \tab Get a BAIDU GCM channel \cr
\link[=pinpoint_get_campaign]{get_campaign} \tab Returns information about a campaign \cr
\link[=pinpoint_get_campaign_activities]{get_campaign_activities} \tab Returns information about the activity performed by a campaign \cr
\link[=pinpoint_get_campaign_version]{get_campaign_version} \tab Returns information about a specific version of a campaign \cr
\link[=pinpoint_get_campaign_versions]{get_campaign_versions} \tab Returns information about your campaign versions \cr
\link[=pinpoint_get_campaigns]{get_campaigns} \tab Returns information about your campaigns \cr
\link[=pinpoint_get_channels]{get_channels} \tab Get all channels \cr
\link[=pinpoint_get_email_channel]{get_email_channel} \tab Get an email channel \cr
\link[=pinpoint_get_endpoint]{get_endpoint} \tab Returns information about an endpoint \cr
\link[=pinpoint_get_event_stream]{get_event_stream} \tab Returns the event stream for an app \cr
\link[=pinpoint_get_export_job]{get_export_job} \tab Returns information about an export job \cr
\link[=pinpoint_get_export_jobs]{get_export_jobs} \tab Returns information about your export jobs \cr
\link[=pinpoint_get_gcm_channel]{get_gcm_channel} \tab Returns information about the GCM channel for an app \cr
\link[=pinpoint_get_import_job]{get_import_job} \tab Returns information about an import job \cr
\link[=pinpoint_get_import_jobs]{get_import_jobs} \tab Returns information about your import jobs \cr
\link[=pinpoint_get_segment]{get_segment} \tab Returns information about a segment \cr
\link[=pinpoint_get_segment_export_jobs]{get_segment_export_jobs} \tab Returns a list of export jobs for a specific segment \cr
\link[=pinpoint_get_segment_import_jobs]{get_segment_import_jobs} \tab Returns a list of import jobs for a specific segment \cr
\link[=pinpoint_get_segment_version]{get_segment_version} \tab Returns information about a segment version \cr
\link[=pinpoint_get_segment_versions]{get_segment_versions} \tab Returns information about your segment versions \cr
\link[=pinpoint_get_segments]{get_segments} \tab Used to get information about your segments \cr
\link[=pinpoint_get_sms_channel]{get_sms_channel} \tab Get an SMS channel \cr
\link[=pinpoint_get_user_endpoints]{get_user_endpoints} \tab Returns information about the endpoints that are associated with a User ID\cr
\link[=pinpoint_get_voice_channel]{get_voice_channel} \tab Get a Voice Channel \cr
\link[=pinpoint_list_tags_for_resource]{list_tags_for_resource} \tab List tags for resource \cr
\link[=pinpoint_phone_number_validate]{phone_number_validate} \tab Returns information about the specified phone number \cr
\link[=pinpoint_put_event_stream]{put_event_stream} \tab Use to create or update the event stream for an app \cr
\link[=pinpoint_put_events]{put_events} \tab Use to record events for endpoints \cr
\link[=pinpoint_remove_attributes]{remove_attributes} \tab Used to remove the attributes for an app \cr
\link[=pinpoint_send_messages]{send_messages} \tab Used to send a direct message \cr
\link[=pinpoint_send_users_messages]{send_users_messages} \tab Used to send a message to a list of users \cr
\link[=pinpoint_tag_resource]{tag_resource} \tab Tag resource \cr
\link[=pinpoint_untag_resource]{untag_resource} \tab Untag resource \cr
\link[=pinpoint_update_adm_channel]{update_adm_channel} \tab Update an ADM channel \cr
\link[=pinpoint_update_apns_channel]{update_apns_channel} \tab Use to update the APNs channel for an app \cr
\link[=pinpoint_update_apns_sandbox_channel]{update_apns_sandbox_channel} \tab Update an APNS sandbox channel \cr
\link[=pinpoint_update_apns_voip_channel]{update_apns_voip_channel} \tab Update an APNS VoIP channel \cr
\link[=pinpoint_update_apns_voip_sandbox_channel]{update_apns_voip_sandbox_channel} \tab Update an APNS VoIP sandbox channel \cr
\link[=pinpoint_update_application_settings]{update_application_settings} \tab Used to update the settings for an app \cr
\link[=pinpoint_update_baidu_channel]{update_baidu_channel} \tab Update a BAIDU GCM channel \cr
\link[=pinpoint_update_campaign]{update_campaign} \tab Use to update a campaign \cr
\link[=pinpoint_update_email_channel]{update_email_channel} \tab Update an email channel \cr
\link[=pinpoint_update_endpoint]{update_endpoint} \tab Creates or updates an endpoint \cr
\link[=pinpoint_update_endpoints_batch]{update_endpoints_batch} \tab Use to update a batch of endpoints \cr
\link[=pinpoint_update_gcm_channel]{update_gcm_channel} \tab Use to update the GCM channel for an app \cr
\link[=pinpoint_update_segment]{update_segment} \tab Used to update a segment \cr
\link[=pinpoint_update_sms_channel]{update_sms_channel} \tab Update an SMS channel \cr
\link[=pinpoint_update_voice_channel]{update_voice_channel} \tab Update an Voice channel
}
}

\examples{
\donttest{svc <- pinpoint()
svc$create_app(
  Foo = 123
)}

}
