% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_delete_configuration_set_tracking_options}
\alias{ses_delete_configuration_set_tracking_options}
\title{Deletes an association between a configuration set and a custom domain
for open and click event tracking}
\usage{
ses_delete_configuration_set_tracking_options(ConfigurationSetName)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set from which you want to delete the
tracking options.}
}
\description{
Deletes an association between a configuration set and a custom domain
for open and click event tracking.
}
\details{
By default, images and links used for tracking open and click events are
hosted on domains operated by Amazon SES. You can configure a subdomain
of your own to handle these events. For information about using custom
domains, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/configure-custom-open-click-domains.html}{Amazon SES Developer Guide}.

Deleting this kind of association will result in emails sent using the
specified configuration set to capture open and click events using the
standard, Amazon SES-operated domains.
}
\section{Request syntax}{
\preformatted{svc$delete_configuration_set_tracking_options(
  ConfigurationSetName = "string"
)
}
}

\keyword{internal}
