# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS RDS DataService
#'
#' @description
#' AWS RDS DataService provides Http Endpoint to query RDS databases.
#'
#' @examples
#' \donttest{svc <- rdsdataservice()
#' svc$execute_sql(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=rdsdataservice_execute_sql]{execute_sql} \tab Executes any SQL statement on the target database synchronously
#' }
#'
#' @rdname rdsdataservice
#' @export
rdsdataservice <- function() {
  .rdsdataservice$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.rdsdataservice <- list()

.rdsdataservice$operations <- list()

.rdsdataservice$metadata <- list(
  service_name = "rdsdataservice",
  endpoints = list("*" = "rdsdataservice.{region}.amazonaws.com", "cn-*" = "rdsdataservice.{region}.amazonaws.com.cn"),
  service_id = "RDS Data",
  api_version = "2018-08-01",
  signing_name = "rds-data",
  json_version = "1.1",
  target_prefix = ""
)

.rdsdataservice$handlers <- new_handlers("restjson", "v4")

.rdsdataservice$service <- function() {
  new_service(.rdsdataservice$metadata, .rdsdataservice$handlers)
}
