% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_cache_security_group}
\alias{elasticache_create_cache_security_group}
\title{Creates a new cache security group}
\usage{
elasticache_create_cache_security_group(CacheSecurityGroupName,
  Description)
}
\arguments{
\item{CacheSecurityGroupName}{[required] A name for the cache security group. This value is stored as a lowercase
string.

Constraints: Must contain no more than 255 alphanumeric characters.
Cannot be the word "Default".

Example: \code{mysecuritygroup}}

\item{Description}{[required] A description for the cache security group.}
}
\description{
Creates a new cache security group. Use a cache security group to
control access to one or more clusters.
}
\details{
Cache security groups are only used when you are creating a cluster
outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are
creating a cluster inside of a VPC, use a cache subnet group instead.
For more information, see
\href{http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html}{CreateCacheSubnetGroup}.
}
\section{Request syntax}{
\preformatted{svc$create_cache_security_group(
  CacheSecurityGroupName = "string",
  Description = "string"
)
}
}

\keyword{internal}
