% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_get_item}
\alias{dynamodb_get_item}
\title{The GetItem operation returns a set of attributes for the item with the
given primary key}
\usage{
dynamodb_get_item(
  TableName,
  Key,
  AttributesToGet = NULL,
  ConsistentRead = NULL,
  ReturnConsumedCapacity = NULL,
  ProjectionExpression = NULL,
  ExpressionAttributeNames = NULL
)
}
\arguments{
\item{TableName}{[required] The name of the table containing the requested item.}

\item{Key}{[required] A map of attribute names to \code{AttributeValue} objects, representing the
primary key of the item to retrieve.

For the primary key, you must provide all of the attributes. For
example, with a simple primary key, you only need to provide a value for
the partition key. For a composite primary key, you must provide values
for both the partition key and the sort key.}

\item{AttributesToGet}{This is a legacy parameter. Use \code{ProjectionExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html}{AttributesToGet}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConsistentRead}{Determines the read consistency model: If set to \code{true}, then the
operation uses strongly consistent reads; otherwise, the operation uses
eventually consistent reads.}

\item{ReturnConsumedCapacity}{}

\item{ProjectionExpression}{A string that identifies one or more attributes to retrieve from the
table. These attributes can include scalars, sets, or elements of a JSON
document. The attributes in the expression must be separated by commas.

If no attribute names are specified, then all attributes are returned.
If any of the requested attributes are not found, they do not appear in
the result.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeNames}{One or more substitution tokens for attribute names in an expression.
The following are some use cases for using \code{ExpressionAttributeNames}:
\itemize{
\item To access an attribute whose name conflicts with a DynamoDB reserved
word.
\item To create a placeholder for repeating occurrences of an attribute
name in an expression.
\item To prevent special characters in an attribute name from being
misinterpreted in an expression.
}

Use the \strong{#} character in an expression to dereference an attribute
name. For example, consider the following attribute name:
\itemize{
\item \code{Percentile}
}

The name of this attribute conflicts with a reserved word, so it cannot
be used directly in an expression. (For the complete list of reserved
words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}). To work around this, you
could specify the following for \code{ExpressionAttributeNames}:
\itemize{
\item \code{{"#P":"Percentile"}}
}

You could then use this substitution in an expression, as in this
example:
\itemize{
\item \verb{#P = :val}
}

Tokens that begin with the \strong{:} character are \emph{expression attribute
values}, which are placeholders for the actual value at runtime.

For more information on expression attribute names, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Attributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}
}
\description{
The \code{\link[=dynamodb_get_item]{get_item}} operation returns a set of attributes for the item with the given primary key. If there is no matching item, \code{\link[=dynamodb_get_item]{get_item}} does not return any data and there will be no \code{Item} element in the response.

See \url{https://paws-r.github.io/docs/dynamodb/get_item.html} for full documentation.
}
\keyword{internal}
