% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_engine_default_cluster_parameters}
\alias{rds_describe_engine_default_cluster_parameters}
\title{Returns the default engine and system parameter information for the
cluster database engine}
\usage{
rds_describe_engine_default_cluster_parameters(
  DBParameterGroupFamily,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{DBParameterGroupFamily}{[required] The name of the DB cluster parameter group family to return engine
parameter information for.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_engine_default_cluster_parameters]{describe_engine_default_cluster_parameters}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns the default engine and system parameter information for the cluster database engine.

See \url{https://paws-r.github.io/docs/rds/describe_engine_default_cluster_parameters.html} for full documentation.
}
\keyword{internal}
