# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Keyspaces
#'
#' @description
#' Amazon Keyspaces (for Apache Cassandra) is a scalable, highly available,
#' and managed Apache Cassandra-compatible database service. Amazon
#' Keyspaces makes it easy to migrate, run, and scale Cassandra workloads
#' in the Amazon Web Services Cloud. With just a few clicks on the Amazon
#' Web Services Management Console or a few lines of code, you can create
#' keyspaces and tables in Amazon Keyspaces, without deploying any
#' infrastructure or installing software.
#' 
#' In addition to supporting Cassandra Query Language (CQL) requests via
#' open-source Cassandra drivers, Amazon Keyspaces supports data definition
#' language (DDL) operations to manage keyspaces and tables using the
#' Amazon Web Services SDK and CLI, as well as infrastructure as code (IaC)
#' services and tools such as CloudFormation and Terraform. This API
#' reference describes the supported DDL operations in detail.
#' 
#' For the list of all supported CQL APIs, see [Supported Cassandra APIs,
#' operations, and data types in Amazon
#' Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/cassandra-apis.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' 
#' To learn how Amazon Keyspaces API actions are recorded with CloudTrail,
#' see [Amazon Keyspaces information in
#' CloudTrail](https://docs.aws.amazon.com/keyspaces/latest/devguide/logging-using-cloudtrail.html#service-name-info-in-cloudtrail)
#' in the *Amazon Keyspaces Developer Guide*.
#' 
#' For more information about Amazon Web Services APIs, for example how to
#' implement retry logic or how to sign Amazon Web Services API requests,
#' see [Amazon Web Services
#' APIs](https://docs.aws.amazon.com/general/latest/gr/) in the *General
#' Reference*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- keyspaces(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- keyspaces()
#' svc$create_keyspace(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=keyspaces_create_keyspace]{create_keyspace} \tab The CreateKeyspace operation adds a new keyspace to your account\cr
#'  \link[=keyspaces_create_table]{create_table} \tab The CreateTable operation adds a new table to the specified keyspace\cr
#'  \link[=keyspaces_delete_keyspace]{delete_keyspace} \tab The DeleteKeyspace operation deletes a keyspace and all of its tables\cr
#'  \link[=keyspaces_delete_table]{delete_table} \tab The DeleteTable operation deletes a table and all of its data\cr
#'  \link[=keyspaces_get_keyspace]{get_keyspace} \tab Returns the name and the Amazon Resource Name (ARN) of the specified table\cr
#'  \link[=keyspaces_get_table]{get_table} \tab Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata\cr
#'  \link[=keyspaces_list_keyspaces]{list_keyspaces} \tab Returns a list of keyspaces\cr
#'  \link[=keyspaces_list_tables]{list_tables} \tab Returns a list of tables for a specified keyspace\cr
#'  \link[=keyspaces_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of all tags associated with the specified Amazon Keyspaces resource\cr
#'  \link[=keyspaces_restore_table]{restore_table} \tab Restores the specified table to the specified point in time within the earliest_restorable_timestamp and the current time\cr
#'  \link[=keyspaces_tag_resource]{tag_resource} \tab Associates a set of tags with a Amazon Keyspaces resource\cr
#'  \link[=keyspaces_untag_resource]{untag_resource} \tab Removes the association of tags from a Amazon Keyspaces resource\cr
#'  \link[=keyspaces_update_table]{update_table} \tab Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname keyspaces
#' @export
keyspaces <- function(config = list()) {
  svc <- .keyspaces$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.keyspaces <- list()

.keyspaces$operations <- list()

.keyspaces$metadata <- list(
  service_name = "keyspaces",
  endpoints = list("*" = list(endpoint = "cassandra.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cassandra.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cassandra.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cassandra.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Keyspaces",
  api_version = "2022-02-10",
  signing_name = "cassandra",
  json_version = "1.0",
  target_prefix = "KeyspacesService"
)

.keyspaces$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.keyspaces$metadata, handlers, config)
}
