% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdbelastic_operations.R
\name{docdbelastic_create_cluster}
\alias{docdbelastic_create_cluster}
\title{Creates a new Elastic DocumentDB cluster and returns its Cluster
structure}
\usage{
docdbelastic_create_cluster(
  adminUserName,
  adminUserPassword,
  authType,
  clientToken = NULL,
  clusterName,
  kmsKeyId = NULL,
  preferredMaintenanceWindow = NULL,
  shardCapacity,
  shardCount,
  subnetIds = NULL,
  tags = NULL,
  vpcSecurityGroupIds = NULL
)
}
\arguments{
\item{adminUserName}{[required] The name of the Elastic DocumentDB cluster administrator.

\emph{Constraints}:
\itemize{
\item Must be from 1 to 63 letters or numbers.
\item The first character must be a letter.
\item Cannot be a reserved word.
}}

\item{adminUserPassword}{[required] The password for the Elastic DocumentDB cluster administrator and can
contain any printable ASCII characters.

\emph{Constraints}:
\itemize{
\item Must contain from 8 to 100 characters.
\item Cannot contain a forward slash (/), double quote ("), or the "at"
symbol (@).
}}

\item{authType}{[required] The authentication type for the Elastic DocumentDB cluster.}

\item{clientToken}{The client token for the Elastic DocumentDB cluster.}

\item{clusterName}{[required] The name of the new Elastic DocumentDB cluster. This parameter is stored
as a lowercase string.

\emph{Constraints}:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

\emph{Example}: \code{my-cluster}}

\item{kmsKeyId}{The KMS key identifier to use to encrypt the new Elastic DocumentDB
cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a cluster using the same Amazon
account that owns this KMS encryption key, you can use the KMS key alias
instead of the ARN as the KMS encryption key.

If an encryption key is not specified, Elastic DocumentDB uses the
default encryption key that KMS creates for your account. Your account
has a different default encryption key for each Amazon Region.}

\item{preferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

\emph{Format}: \code{ddd:hh24:mi-ddd:hh24:mi}

\emph{Default}: a 30-minute window selected at random from an 8-hour block of
time for each Amazon Web Services Region, occurring on a random day of
the week.

\emph{Valid days}: Mon, Tue, Wed, Thu, Fri, Sat, Sun

\emph{Constraints}: Minimum 30-minute window.}

\item{shardCapacity}{[required] The capacity of each shard in the new Elastic DocumentDB cluster.}

\item{shardCount}{[required] The number of shards to create in the new Elastic DocumentDB cluster.}

\item{subnetIds}{The Amazon EC2 subnet IDs for the new Elastic DocumentDB cluster.}

\item{tags}{The tags to be assigned to the new Elastic DocumentDB cluster.}

\item{vpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the new Elastic
DocumentDB cluster.}
}
\description{
Creates a new Elastic DocumentDB cluster and returns its Cluster structure.

See \url{https://www.paws-r-sdk.com/docs/docdbelastic_create_cluster/} for full documentation.
}
\keyword{internal}
